/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.javascript.lcov.CoverageSensor;

public final class LCOVParser {
    private static final Logger LOG = LoggerFactory.getLogger(LCOVParser.class);
    private static final String SF = "SF:";
    private static final String DA = "DA:";
    private static final String BRDA = "BRDA:";
    private final File moduleBaseDir;

    public LCOVParser(File moduleBaseDir) {
        this.moduleBaseDir = moduleBaseDir;
    }

    public Map<String, CoverageMeasuresBuilder> parseFile(File file) {
        List lines;
        try {
            lines = FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            throw new SonarException("Could not read content from file: " + file, (Throwable)e);
        }
        return this.parse(lines);
    }

    public Map<String, CoverageMeasuresBuilder> parse(List<String> lines) {
        HashMap files = Maps.newHashMap();
        FileData fileData = new FileData();
        for (String line : lines) {
            if (line.startsWith(SF)) {
                String filePath = line.substring(SF.length());
                try {
                    filePath = CoverageSensor.getIOFile(this.moduleBaseDir, filePath).getCanonicalPath();
                }
                catch (IOException e) {
                    filePath = "";
                    LOG.error("Unable to retreive coverage onfo for file {}, because: {}", (Object)filePath, (Object)e);
                }
                if ((fileData = (FileData)files.get(filePath)) != null) continue;
                fileData = new FileData();
                files.put(filePath, fileData);
                continue;
            }
            if (line.startsWith(DA)) {
                String execution = line.substring(DA.length());
                String executionCount = execution.substring(execution.indexOf(44) + 1);
                String lineNumber = execution.substring(0, execution.indexOf(44));
                fileData.addLine(Integer.valueOf(lineNumber), Integer.valueOf(executionCount));
                continue;
            }
            if (!line.startsWith(BRDA)) continue;
            String[] tokens = line.substring(BRDA.length()).trim().split(",");
            String lineNumber = tokens[0];
            String branchNumber = tokens[1] + tokens[2];
            String taken = tokens[3];
            fileData.addBranch(Integer.valueOf(lineNumber), branchNumber, "-".equals(taken) ? 0 : Integer.valueOf(taken));
        }
        HashMap coveredFiles = Maps.newHashMap();
        for (Map.Entry e : files.entrySet()) {
            coveredFiles.put(e.getKey(), ((FileData)e.getValue()).convert());
        }
        return coveredFiles;
    }

    private static class FileData {
        private Map<Integer, Map<String, Integer>> branches = Maps.newHashMap();
        private Map<Integer, Integer> hits = Maps.newHashMap();

        private FileData() {
        }

        public void addBranch(Integer lineNumber, String branchNumber, Integer taken) {
            HashMap branchesForLine = this.branches.get(lineNumber);
            if (branchesForLine == null) {
                branchesForLine = Maps.newHashMap();
                this.branches.put(lineNumber, branchesForLine);
            }
            Integer currentValue = (Integer)branchesForLine.get(branchNumber);
            branchesForLine.put(branchNumber, (Integer)Objects.firstNonNull((Object)currentValue, (Object)0) + taken);
        }

        public void addLine(Integer lineNumber, Integer executionCount) {
            Integer currentValue = this.hits.get(lineNumber);
            this.hits.put(lineNumber, (Integer)Objects.firstNonNull((Object)currentValue, (Object)0) + executionCount);
        }

        public CoverageMeasuresBuilder convert() {
            CoverageMeasuresBuilder result = CoverageMeasuresBuilder.create();
            for (Map.Entry<Integer, Integer> entry : this.hits.entrySet()) {
                result.setHits(entry.getKey().intValue(), entry.getValue().intValue());
            }
            for (Map.Entry<Integer, Object> entry : this.branches.entrySet()) {
                int conditions = ((Map)entry.getValue()).size();
                int covered = 0;
                for (Integer taken : ((Map)entry.getValue()).values()) {
                    if (taken <= 0) continue;
                    ++covered;
                }
                result.setConditions(entry.getKey().intValue(), conditions, covered);
            }
            return result;
        }
    }
}

