/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;

@Rule(key="NestedIfDepth", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class NestedIfDepthCheck
extends SquidCheck<Grammar> {
    private int nestingLevel;
    private static final int DEFAULT_MAXIMUM_NESTING_LEVEL = 3;
    @RuleProperty(key="maximumNestingLevel", defaultValue="3")
    public int maximumNestingLevel = 3;

    public int getMaximumNestingLevel() {
        return this.maximumNestingLevel;
    }

    public GrammarRuleKey getIfRule() {
        return PythonGrammar.IF_STMT;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{this.getIfRule()});
    }

    public void visitNode(AstNode astNode) {
        ++this.nestingLevel;
        if (this.nestingLevel == this.getMaximumNestingLevel() + 1) {
            this.getContext().createLineViolation((CodeCheck)this, "This if has a nesting level of {0}, which is higher than the maximum allowed {1}.", astNode, new Object[]{this.nestingLevel, this.getMaximumNestingLevel()});
        }
    }

    public void leaveNode(AstNode astNode) {
        --this.nestingLevel;
    }
}

