/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1721", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UselessParenthesisAfterKeywordCheck
extends SquidCheck<Grammar> {
    private static final Map<PythonGrammar, String> KEYWORDS_FOLLOWED_BY_TEST = ImmutableMap.of((Object)PythonGrammar.ASSERT_STMT, (Object)"assert", (Object)PythonGrammar.RAISE_STMT, (Object)"raise", (Object)PythonGrammar.WHILE_STMT, (Object)"while");

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.ASSERT_STMT, PythonGrammar.DEL_STMT, PythonGrammar.IF_STMT, PythonGrammar.FOR_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.RETURN_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.YIELD_EXPR, PythonGrammar.EXCEPT_CLAUSE, PythonGrammar.NOT_TEST});
    }

    public void visitNode(AstNode node) {
        String keyword = KEYWORDS_FOLLOWED_BY_TEST.get(node.getType());
        if (keyword != null) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}), keyword, node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.DEL_STMT})) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}), "del", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.IF_STMT})) {
            List testNodes = node.getChildren(new AstNodeType[]{PythonGrammar.TEST});
            this.checkParenthesis((AstNode)testNodes.get(0), "if", node);
            if (testNodes.size() > 1) {
                this.checkParenthesis((AstNode)testNodes.get(1), "elif", (AstNode)testNodes.get(1));
            }
        } else if (node.is(new AstNodeType[]{PythonGrammar.FOR_STMT})) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.EXPRLIST}), "for", node);
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}), "in", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.RETURN_STMT})) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}), "return", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.YIELD_EXPR})) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}), "yield", node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.EXCEPT_CLAUSE})) {
            this.visitExceptClause(node);
        } else if (node.is(new AstNodeType[]{PythonGrammar.NOT_TEST})) {
            this.visitNotTest(node);
        }
    }

    private void visitNotTest(AstNode node) {
        boolean hasUselessParenthesis = node.select().children((AstNodeType)PythonGrammar.ATOM).children((AstNodeType)PythonGrammar.TESTLIST_COMP).children((AstNodeType)PythonGrammar.TEST).children(new AstNodeType[]{PythonGrammar.ATOM, PythonGrammar.COMPARISON}).isNotEmpty();
        if (hasUselessParenthesis) {
            this.checkParenthesis(node.getFirstChild().getNextSibling(), "not", node);
        }
    }

    private void visitExceptClause(AstNode node) {
        int nbTests = node.select().children((AstNodeType)PythonGrammar.TEST).children((AstNodeType)PythonGrammar.ATOM).children((AstNodeType)PythonGrammar.TESTLIST_COMP).children((AstNodeType)PythonGrammar.TEST).size();
        if (nbTests == 1) {
            this.checkParenthesis(node.getFirstChild(new AstNodeType[]{PythonGrammar.TEST}), "except", node);
        }
    }

    private void checkParenthesis(AstNode child, String keyword, AstNode errorNode) {
        if (child != null && child.getToken().getType() == PythonPunctuator.LPARENTHESIS && this.isOnASingleLine(child)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the parentheses after this \"{0}\" keyword", errorNode, new Object[]{keyword});
        }
    }

    private boolean isOnASingleLine(AstNode node) {
        return node.getTokenLine() == node.getLastToken().getLine();
    }
}

