/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.AstScannerExceptionHandler;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="ParsingError", priority=Priority.MAJOR, name="Parser failure")
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class ParsingErrorCheck
extends SquidCheck<Grammar>
implements AstScannerExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ParsingErrorCheck.class);
    public static final String CHECK_KEY = "ParsingError";

    public void processException(Exception e) {
        StringWriter exception = new StringWriter();
        e.printStackTrace(new PrintWriter(exception));
        LOG.debug("Parsing error", (Throwable)e);
        this.getContext().createFileViolation((CodeCheck)this, exception.toString(), new Object[0]);
    }

    public void processRecognitionException(RecognitionException e) {
        this.getContext().createLineViolation((CodeCheck)this, e.getMessage(), e.getLine(), new Object[0]);
    }
}

