/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.api;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.TokenType;

public enum PythonKeyword implements TokenType
{
    FALSE("False"),
    NONE("None"),
    TRUE("True"),
    AND("and"),
    AS("as"),
    ASSERT("assert"),
    BREAK("break"),
    CLASS("class"),
    CONTINUE("continue"),
    DEF("def"),
    DEL("del"),
    ELIF("elif"),
    ELSE("else"),
    EXCEPT("except"),
    FINALLY("finally"),
    FOR("for"),
    FROM("from"),
    GLOBAL("global"),
    IF("if"),
    IMPORT("import"),
    IN("in"),
    IS("is"),
    LAMBDA("lambda"),
    NONLOCAL("nonlocal"),
    NOT("not"),
    OR("or"),
    PASS("pass"),
    RAISE("raise"),
    RETURN("return"),
    TRY("try"),
    WHILE("while"),
    WITH("with"),
    YIELD("yield");

    private final String value;

    private PythonKeyword(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name();
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasToBeSkippedFromAst(AstNode node) {
        return false;
    }

    public static String[] keywordValues() {
        PythonKeyword[] keywordsEnum = PythonKeyword.values();
        String[] keywords = new String[keywordsEnum.length];
        for (int i = 0; i < keywords.length; ++i) {
            keywords[i] = keywordsEnum[i].getValue();
        }
        return keywords;
    }
}

