/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;

public class PythonLinesOfCodeVisitor<GRAMMAR extends Grammar>
extends SquidAstVisitor<GRAMMAR>
implements AstAndTokenVisitor {
    private final MetricDef metric;
    private int lastTokenLine;

    public PythonLinesOfCodeVisitor(MetricDef metric) {
        this.metric = metric;
    }

    @Override
    public void visitFile(AstNode node) {
        this.lastTokenLine = -1;
    }

    @Override
    public void visitToken(Token token) {
        if (token.getType() != GenericTokenType.EOF && token.getType() != PythonTokenType.DEDENT && token.getType() != PythonTokenType.INDENT && token.getType() != PythonTokenType.NEWLINE) {
            String[] tokenLines = token.getValue().split("\n", -1);
            int firstLineAlreadyCounted = this.lastTokenLine == token.getLine() ? 1 : 0;
            this.getContext().peekSourceCode().add(this.metric, tokenLines.length - firstLineAlreadyCounted);
            this.lastTokenLine = token.getLine() + tokenLines.length - 1;
        }
    }
}

