/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import org.sonar.api.utils.SonarException;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;

public abstract class AbstractFileComplexityCheck<G extends Grammar>
extends SquidCheck<G> {
    public abstract int getMaximumFileComplexity();

    public abstract MetricDef getComplexityMetric();

    @Override
    public void init() {
        if (this.getMaximumFileComplexity() <= 0) {
            throw new SonarException("The complexity threshold must be set to a value greater than 0, but given: " + this.getMaximumFileComplexity());
        }
    }

    @Override
    public void leaveFile(AstNode astNode) {
        SourceFile sourceFile = (SourceFile)this.getContext().peekSourceCode();
        int fileComplexity = ChecksHelper.getRecursiveMeasureInt(sourceFile, this.getComplexityMetric());
        if (fileComplexity > this.getMaximumFileComplexity()) {
            this.getContext().createFileViolation(this, "The file is too complex ({0} while maximum allowed is set to {1}).", fileComplexity, this.getMaximumFileComplexity());
        }
    }
}

