/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.F;
import fj.F0;
import fj.F1Functions;
import fj.F2;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.Try;
import fj.Unit;
import fj.data.IO;
import fj.data.Iteratee;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Option;
import fj.data.SafeIO;
import fj.data.State;
import fj.data.Stream;
import fj.data.Validation;
import fj.function.Try0;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class IOFunctions {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final F<Reader, IO<Unit>> closeReader = IOFunctions::closeReader;
    public static final IO<Unit> ioUnit = IOFunctions.unit(Unit.unit());
    public static final BufferedReader stdinBufferedReader = new BufferedReader(new InputStreamReader(System.in));

    private IOFunctions() {
    }

    public static <A> Try0<A, IOException> toTry(IO<A> io) {
        return io::run;
    }

    public static <A> P1<Validation<IOException, A>> p(IO<A> io) {
        return Try.f(IOFunctions.toTry(io));
    }

    public static <A> IO<A> fromF(F0<A> p) {
        return p::f;
    }

    public static <A> IO<A> fromTry(Try0<A, ? extends IOException> t) {
        return t::f;
    }

    public static <A> SafeIO<A> toSafe(IO<A> io) {
        return () -> {
            try {
                return io.run();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <A> A runSafe(IO<A> io) {
        return IOFunctions.toSafe(io).run();
    }

    public static IO<Unit> closeReader(Reader r) {
        return () -> {
            r.close();
            return Unit.unit();
        };
    }

    public static <A> IO<Iteratee.IterV<String, A>> enumFileLines(File f, Option<Charset> encoding, Iteratee.IterV<String, A> i) {
        return IOFunctions.bracket(IOFunctions.bufferedReader(f, encoding), Function.vary(closeReader), Function.partialApply2(IOFunctions.lineReader(), i));
    }

    public static <A> IO<Iteratee.IterV<char[], A>> enumFileCharChunks(File f, Option<Charset> encoding, Iteratee.IterV<char[], A> i) {
        return IOFunctions.bracket(IOFunctions.fileReader(f, encoding), Function.vary(closeReader), Function.partialApply2(IOFunctions.charChunkReader(), i));
    }

    public static <A> IO<Iteratee.IterV<Character, A>> enumFileChars(File f, Option<Charset> encoding, Iteratee.IterV<Character, A> i) {
        return IOFunctions.bracket(IOFunctions.fileReader(f, encoding), Function.vary(closeReader), Function.partialApply2(IOFunctions.charChunkReader2(), i));
    }

    public static IO<BufferedReader> bufferedReader(File f, Option<Charset> encoding) {
        return IOFunctions.map(IOFunctions.fileReader(f, encoding), BufferedReader::new);
    }

    public static IO<Reader> fileReader(File f, Option<Charset> encoding) {
        return () -> {
            FileInputStream fis = new FileInputStream(f);
            return encoding.isNone() ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, (Charset)encoding.some());
        };
    }

    public static <A, B, C> IO<C> bracket(IO<A> init, F<A, IO<B>> fin, F<A, IO<C>> body) {
        return () -> {
            Object a = init.run();
            try (Closeable finAsCloseable = ((IO)fin.f(a))::run;){
                Object a2 = ((IO)body.f(a)).run();
                return a2;
            }
        };
    }

    public static <A> IO<A> unit(A a) {
        return () -> a;
    }

    public static <A> IO<A> lazy(F0<A> p) {
        return IOFunctions.fromF(p);
    }

    public static <A> IO<A> lazy(F<Unit, A> f) {
        return () -> f.f(Unit.unit());
    }

    public static <A> SafeIO<A> lazySafe(F<Unit, A> f) {
        return () -> f.f(Unit.unit());
    }

    public static <A> SafeIO<A> lazySafe(F0<A> f) {
        return f::f;
    }

    public static <A> F<BufferedReader, F<Iteratee.IterV<String, A>, IO<Iteratee.IterV<String, A>>>> lineReader() {
        return x$0 -> new LineReader((BufferedReader)x$0);
    }

    public static <A> F<Reader, F<Iteratee.IterV<char[], A>, IO<Iteratee.IterV<char[], A>>>> charChunkReader() {
        return CharChunkReader::new;
    }

    public static <A> F<Reader, F<Iteratee.IterV<Character, A>, IO<Iteratee.IterV<Character, A>>>> charChunkReader2() {
        return CharChunkReader2::new;
    }

    public static <A, B> IO<B> map(IO<A> io, F<A, B> f) {
        return () -> f.f(io.run());
    }

    public static <A, B> IO<B> as(IO<A> io, B b) {
        return IOFunctions.map(io, ignored -> b);
    }

    public static <A> IO<Unit> voided(IO<A> io) {
        return IOFunctions.as(io, Unit.unit());
    }

    public static <A, B> IO<B> bind(IO<A> io, F<A, IO<B>> f) {
        return () -> ((IO)f.f(io.run())).run();
    }

    public static IO<Unit> when(Boolean b, IO<Unit> io) {
        return b != false ? io : ioUnit;
    }

    public static IO<Unit> unless(Boolean b, IO<Unit> io) {
        return IOFunctions.when(b == false, io);
    }

    public static <A> IO<List<A>> sequence(List<IO<A>> list) {
        F2<IO, IO, IO> f2 = (io, ioList) -> IOFunctions.bind(ioList, xs -> IOFunctions.map(io, x -> List.cons(x, xs)));
        return list.foldRight(f2, IOFunctions.unit(List.nil()));
    }

    public static <A> IO<Stream<A>> sequence(Stream<IO<A>> stream) {
        F2<IO, IO, IO> f2 = (ioList, io) -> IOFunctions.bind(ioList, xs -> IOFunctions.map(io, x -> Stream.cons(x, () -> xs)));
        return stream.foldLeft(f2, IOFunctions.unit(Stream.nil()));
    }

    public static <A> IO<A> join(IO<IO<A>> io1) {
        return IOFunctions.bind(io1, io2 -> io2);
    }

    public static <A> SafeIO<Validation<IOException, A>> toSafeValidation(IO<A> io) {
        return () -> Try.f(io::run)._1();
    }

    public static <A, B> IO<B> append(IO<A> io1, IO<B> io2) {
        return () -> {
            io1.run();
            return io2.run();
        };
    }

    public static <A, B> IO<A> left(IO<A> io1, IO<B> io2) {
        return () -> {
            Object a = io1.run();
            io2.run();
            return a;
        };
    }

    public static <A, B> IO<B> flatMap(IO<A> io, F<A, IO<B>> f) {
        return IOFunctions.bind(io, f);
    }

    public static IO<Unit> interactWhile(F<String, Boolean> condition, F<String, String> transform) {
        Stream s1 = Stream.repeat(IOFunctions.stdinReadLine());
        IO<Stream<String>> io = IOFunctions.sequenceWhile(s1, condition);
        return () -> ((Stream)IOFunctions.runSafe(io)).foreach(s -> IOFunctions.runSafe(IOFunctions.stdoutPrintln((String)transform.f((String)s))));
    }

    public static <A> IO<Stream<A>> sequenceWhileEager(Stream<IO<A>> stream, F<A, Boolean> f) {
        return () -> {
            boolean loop = true;
            Stream input = stream;
            Stream result = Stream.nil();
            while (loop) {
                if (input.isEmpty()) {
                    loop = false;
                    continue;
                }
                Object a = ((IO)input.head()).run();
                if (!((Boolean)f.f(a)).booleanValue()) {
                    loop = false;
                    continue;
                }
                input = input.tail()._1();
                result = result.cons(a);
            }
            return result.reverse();
        };
    }

    public static <A> IO<Stream<A>> sequenceWhile(Stream<IO<A>> stream, F<A, Boolean> f) {
        return () -> {
            if (stream.isEmpty()) {
                return Stream.nil();
            }
            IO io = (IO)stream.head();
            Object a = io.run();
            if (!((Boolean)f.f(a)).booleanValue()) {
                return Stream.nil();
            }
            IO io2 = IOFunctions.sequenceWhile(stream.tail()._1(), f);
            SafeIO<Stream> s3 = IOFunctions.toSafe(io2::run);
            return Stream.cons(a, s3::run);
        };
    }

    public static <A, B> IO<B> apply(IO<A> io, IO<F<A, B>> iof) {
        return IOFunctions.bind(iof, f -> IOFunctions.map(io, f));
    }

    public static <A, B, C> IO<C> liftM2(IO<A> ioa, IO<B> iob, F2<A, B, C> f) {
        return IOFunctions.bind(ioa, a -> IOFunctions.map(iob, b -> f.f(a, b)));
    }

    public static <A> IO<List<A>> replicateM(IO<A> ioa, int n) {
        return IOFunctions.sequence(List.replicate(n, ioa));
    }

    public static <A> IO<State<BufferedReader, Validation<IOException, String>>> readerState() {
        return () -> State.unit(r -> P.p(r, Try.f(BufferedReader::readLine).f((BufferedReader)r)));
    }

    public static IO<String> stdinReadLine() {
        return stdinBufferedReader::readLine;
    }

    public static IO<Unit> stdoutPrintln(String s) {
        return () -> {
            System.out.println(s);
            return Unit.unit();
        };
    }

    public static IO<Unit> stdoutPrint(String s) {
        return () -> {
            System.out.print(s);
            return Unit.unit();
        };
    }

    public static IO<LazyString> getContents() {
        Stream s = Stream.repeat(() -> stdinBufferedReader.read());
        return IOFunctions.map(IOFunctions.sequenceWhile(s, i -> i != -1), s2 -> LazyString.fromStream(s2.map(i -> Character.valueOf((char)i.intValue()))));
    }

    public static IO<Unit> interact(F<LazyString, LazyString> f) {
        return IOFunctions.bind(IOFunctions.getContents(), ls1 -> {
            LazyString ls2 = (LazyString)f.f((LazyString)ls1);
            return IOFunctions.stdoutPrintln(ls2.toString());
        });
    }

    private static class CharChunkReader2<A>
    implements F<Iteratee.IterV<Character, A>, IO<Iteratee.IterV<Character, A>>> {
        private final Reader r;
        private final F<Iteratee.IterV<Character, A>, Boolean> isDone = i -> i.fold(Function.constant(P.p(true)), Function.constant(P.p(false)))._1();
        private final F<P2<A, Iteratee.Input<Character>>, Iteratee.IterV<Character, A>> done = Bottom.errorF("iteratee is done");

        CharChunkReader2(Reader r) {
            this.r = r;
        }

        @Override
        public IO<Iteratee.IterV<Character, A>> f(Iteratee.IterV<Character, A> it) {
            return () -> {
                Iteratee.IterV<Character, A> i = it;
                while (!this.isDone.f(i).booleanValue()) {
                    char[] buffer = new char[4096];
                    int numRead = this.r.read(buffer);
                    if (numRead == -1) {
                        return i;
                    }
                    if (numRead < buffer.length) {
                        buffer = Arrays.copyOfRange(buffer, 0, numRead);
                    }
                    for (char c : buffer) {
                        Iteratee.Input<Character> input = Iteratee.Input.el(Character.valueOf(c));
                        F cont = Function.apply(input);
                        i = i.fold(this.done, cont);
                    }
                }
                return i;
            };
        }
    }

    private static class CharChunkReader<A>
    implements F<Iteratee.IterV<char[], A>, IO<Iteratee.IterV<char[], A>>> {
        private final Reader r;
        private final F<Iteratee.IterV<char[], A>, Boolean> isDone = i -> i.fold(Function.constant(P.p(true)), Function.constant(P.p(false)))._1();
        private final F<P2<A, Iteratee.Input<char[]>>, P1<Iteratee.IterV<char[], A>>> done = Bottom.errorF("iteratee is done");

        CharChunkReader(Reader r) {
            this.r = r;
        }

        @Override
        public IO<Iteratee.IterV<char[], A>> f(Iteratee.IterV<char[], A> it) {
            return () -> {
                Iteratee.IterV i = it;
                while (!this.isDone.f(i).booleanValue()) {
                    char[] buffer = new char[4096];
                    int numRead = this.r.read(buffer);
                    if (numRead == -1) {
                        return i;
                    }
                    if (numRead < buffer.length) {
                        buffer = Arrays.copyOfRange(buffer, 0, numRead);
                    }
                    Iteratee.Input<char[]> input = Iteratee.Input.el(buffer);
                    F cont = F1Functions.lazy(Function.apply(input));
                    i = (Iteratee.IterV)i.fold(this.done, cont)._1();
                }
                return i;
            };
        }
    }

    private static class LineReader<A>
    implements F<Iteratee.IterV<String, A>, IO<Iteratee.IterV<String, A>>> {
        private final BufferedReader r;
        private final F<Iteratee.IterV<String, A>, Boolean> isDone = i -> i.fold(Function.constant(P.p(true)), Function.constant(P.p(false)))._1();
        private final F<P2<A, Iteratee.Input<String>>, P1<Iteratee.IterV<String, A>>> done = Bottom.errorF("iteratee is done");

        private LineReader(BufferedReader r) {
            this.r = r;
        }

        @Override
        public IO<Iteratee.IterV<String, A>> f(Iteratee.IterV<String, A> it) {
            return () -> {
                Iteratee.IterV i = it;
                while (!this.isDone.f(i).booleanValue()) {
                    String s = this.r.readLine();
                    if (s == null) {
                        return i;
                    }
                    Iteratee.Input<String> input = Iteratee.Input.el(s);
                    F cont = F1Functions.lazy(Function.apply(input));
                    i = (Iteratee.IterV)i.fold(this.done, cont)._1();
                }
                return i;
            };
        }
    }
}

