/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.data.List;
import fj.data.Option;

public final class Doubles {
    public static final F<Double, F<Double, Double>> add = x -> y -> x + y;
    public static final F<Double, F<Double, Double>> multiply = x -> y -> x * y;
    public static final F<Double, F<Double, Double>> subtract = x -> y -> x - y;
    public static final F<Double, Double> negate = x -> x * -1.0;
    public static final F<Double, Double> abs = Math::abs;
    public static final F<Double, F<Double, Double>> remainder = x -> y -> x % y;
    public static final F<Double, F<Double, Double>> power = x -> y -> StrictMath.pow(x, y);
    public static final F<Double, Boolean> even = i -> i % 2.0 == 0.0;
    public static final F<Double, Boolean> gtZero = i -> Double.compare(i, 0.0) > 0;
    public static final F<Double, Boolean> gteZero = i -> Double.compare(i, 0.0) >= 0;
    public static final F<Double, Boolean> ltZero = i -> Double.compare(i, 0.0) < 0;
    public static final F<Double, Boolean> lteZero = i -> Double.compare(i, 0.0) <= 0;

    private Doubles() {
        throw new UnsupportedOperationException();
    }

    public static double sum(List<Double> doubles) {
        return doubles.foldLeft((x, y) -> x + y, Double.valueOf(0.0));
    }

    public static double product(List<Double> doubles) {
        return doubles.foldLeft((x, y) -> x * y, Double.valueOf(1.0));
    }

    public static F<String, Option<Double>> fromString() {
        return s -> {
            try {
                return Option.some(Double.valueOf(s));
            }
            catch (NumberFormatException ignored) {
                return Option.none();
            }
        };
    }
}

