/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import org.gitlab.api.models.GitlabCommitDiff;
import org.gitlab.api.models.GitlabMilestone;
import org.gitlab.api.models.GitlabUser;

public class GitlabMergeRequest {
    public static final String URL = "/merge_requests";
    public static final String STATUS_OPENED = "opened";
    public static final String STATUS_MERGED = "merged";
    public static final String STATUS_CLOSED = "closed";
    private Integer id;
    private Integer iid;
    private String title;
    private String state;
    private String description;
    private boolean closed;
    private boolean merged;
    private GitlabUser author;
    private GitlabUser assignee;
    private GitlabMilestone milestone;
    private String[] labels;
    private List<GitlabCommitDiff> changes;
    private Integer upvotes;
    private Integer downvotes;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="target_branch")
    private String targetBranch;
    @JsonProperty(value="source_branch")
    private String sourceBranch;
    @JsonProperty(value="project_id")
    private Integer projectId;
    @JsonProperty(value="source_project_id")
    private Integer sourceProjectId;
    @JsonProperty(value="target_project_id")
    private Integer targetProjectId;
    @JsonProperty(value="milestone_id")
    private Integer milestoneId;
    @JsonProperty(value="work_in_progress")
    private Boolean workInProgress;
    @JsonProperty(value="merge_when_pipeline_succeeds")
    private Boolean mergeWhenPipelineSucceeds;
    @JsonProperty(value="merge_status")
    private String mergeStatus;
    @JsonProperty(value="sha")
    private String sha;
    @JsonProperty(value="merge_commit_sha")
    private String mergeCommitSHA;
    @JsonProperty(value="user_notes_count")
    private Integer userNotesCount;
    @JsonProperty(value="discussion_locked")
    private Boolean discussionLocked;
    @JsonProperty(value="should_remove_source_branch")
    private Boolean shouldRemoveSourceBranch;
    @JsonProperty(value="force_remove_source_branch")
    private Boolean forceRemoveSourceBranch;
    @JsonProperty(value="web_url")
    private String webUrl;
    private Boolean squash;
    @JsonProperty(value="changes_count")
    private Integer changesCount;
    @JsonProperty(value="merged_by")
    private GitlabUser mergedBy;
    @JsonProperty(value="merged_at")
    private Date mergedAt;
    @JsonProperty(value="closed_by")
    private GitlabUser closedBy;
    @JsonProperty(value="closed_at")
    private Date closedAt;
    @JsonProperty(value="latest_build_started_at")
    private Date latestBuildStartedAt;
    @JsonProperty(value="latest_build_finished_at")
    private Date latestBuildFinishedAt;
    @JsonProperty(value="first_deployed_to_production_at")
    private Date firstDeployedToProductionAt;
    @JsonProperty(value="diff_refs")
    private DiffRefs diffRefs;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Deprecated
    public Integer getMilestoneId() {
        return this.milestoneId;
    }

    @Deprecated
    public void setMilestoneId(Integer id) {
        this.milestoneId = id;
    }

    public Integer getIid() {
        return this.iid;
    }

    public void setIid(Integer iid) {
        this.iid = iid;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public void setTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Integer getSourceProjectId() {
        return this.sourceProjectId;
    }

    public void setSourceProjectId(Integer sourceProjectId) {
        this.sourceProjectId = sourceProjectId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    @Deprecated
    public boolean isClosed() {
        return this.closed;
    }

    @Deprecated
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Deprecated
    public boolean isMerged() {
        return this.merged;
    }

    @Deprecated
    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public GitlabUser getAuthor() {
        return this.author;
    }

    public void setAuthor(GitlabUser author) {
        this.author = author;
    }

    public GitlabUser getAssignee() {
        return this.assignee;
    }

    public void setAssignee(GitlabUser assignee) {
        this.assignee = assignee;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        if (state != null) {
            this.closed = state.equals(STATUS_CLOSED);
            this.merged = state.equals(STATUS_MERGED);
        }
    }

    public GitlabMilestone getMilestone() {
        return this.milestone;
    }

    public void setMilestone(GitlabMilestone milestone) {
        this.milestone = milestone;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public int getUpvotes() {
        return this.upvotes;
    }

    public void setUpvotes(int upvotes) {
        this.upvotes = upvotes;
    }

    public int getDownvotes() {
        return this.downvotes;
    }

    public void setDownvotes(int downvotes) {
        this.downvotes = downvotes;
    }

    public Integer getTargetProjectId() {
        return this.targetProjectId;
    }

    public void setTargetProjectId(Integer targetProjectId) {
        this.targetProjectId = targetProjectId;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public List<GitlabCommitDiff> getChanges() {
        return this.changes;
    }

    public void setChanges(List<GitlabCommitDiff> changes) {
        this.changes = changes;
    }

    public String getMergeCommitSHA() {
        return this.mergeCommitSHA;
    }

    public void setMergeCommitSHA(String mergeCommitSHA) {
        this.mergeCommitSHA = mergeCommitSHA;
    }

    public String getMergeStatus() {
        return this.mergeStatus;
    }

    public void setMergeStatus(String mergeStatus) {
        this.mergeStatus = mergeStatus;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }

    public Boolean isWorkInProgress() {
        return this.workInProgress;
    }

    public Boolean isMergeWhenPipelineSucceeds() {
        return this.mergeWhenPipelineSucceeds;
    }

    public Integer getUserNotesCount() {
        return this.userNotesCount;
    }

    public Boolean isDiscussionLocked() {
        return this.discussionLocked;
    }

    public Boolean isShouldRemoveSourceBranch() {
        return this.shouldRemoveSourceBranch;
    }

    public boolean isForceRemoveSourceBranch() {
        return this.forceRemoveSourceBranch;
    }

    public Boolean isSquash() {
        return this.squash;
    }

    public Integer getChangesCount() {
        return this.changesCount;
    }

    public GitlabUser getMergedBy() {
        return this.mergedBy;
    }

    public Date getMergedAt() {
        return this.mergedAt;
    }

    public GitlabUser getClosedBy() {
        return this.closedBy;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public Date getLatestBuildStartedAt() {
        return this.latestBuildStartedAt;
    }

    public Date getLatestBuildFinishedAt() {
        return this.latestBuildFinishedAt;
    }

    public Date getFirstDeployedToProductionAt() {
        return this.firstDeployedToProductionAt;
    }

    public String getBaseSha() {
        return this.diffRefs == null ? null : this.diffRefs.baseSha;
    }

    public String getHeadSha() {
        return this.diffRefs == null ? null : this.diffRefs.headSha;
    }

    public String getStartSha() {
        return this.diffRefs == null ? null : this.diffRefs.startSha;
    }

    private static class DiffRefs {
        @JsonProperty(value="base_sha")
        private String baseSha;
        @JsonProperty(value="head_sha")
        private String headSha;
        @JsonProperty(value="start_sha")
        private String startSha;

        private DiffRefs() {
        }
    }
}

