/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.server;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.server.DefaultWebSocketServerFactory;
import org.junit.Assert;
import org.junit.Test;

public class DefaultWebSocketServerFactoryTest {
    @Test
    public void testCreateWebSocket() {
        DefaultWebSocketServerFactory webSocketServerFactory = new DefaultWebSocketServerFactory();
        CustomWebSocketAdapter webSocketAdapter = new CustomWebSocketAdapter();
        WebSocketImpl webSocketImpl = webSocketServerFactory.createWebSocket((WebSocketAdapter)webSocketAdapter, (Draft)new Draft_6455());
        Assert.assertNotNull((String)"webSocketImpl != null", (Object)webSocketImpl);
        webSocketImpl = webSocketServerFactory.createWebSocket((WebSocketAdapter)webSocketAdapter, Collections.singletonList(new Draft_6455()));
        Assert.assertNotNull((String)"webSocketImpl != null", (Object)webSocketImpl);
    }

    @Test
    public void testWrapChannel() {
        DefaultWebSocketServerFactory webSocketServerFactory = new DefaultWebSocketServerFactory();
        SocketChannel channel = new Socket().getChannel();
        SocketChannel result = webSocketServerFactory.wrapChannel(channel, null);
        Assert.assertSame((String)"channel == result", (Object)channel, (Object)result);
    }

    @Test
    public void testClose() {
        DefaultWebSocketServerFactory webSocketServerFactory = new DefaultWebSocketServerFactory();
        webSocketServerFactory.close();
    }

    private static class CustomWebSocketAdapter
    extends WebSocketAdapter {
        private CustomWebSocketAdapter() {
        }

        public void onWebsocketMessage(WebSocket conn, String message) {
        }

        public void onWebsocketMessage(WebSocket conn, ByteBuffer blob) {
        }

        public void onWebsocketOpen(WebSocket conn, Handshakedata d) {
        }

        public void onWebsocketClose(WebSocket ws, int code, String reason, boolean remote) {
        }

        public void onWebsocketClosing(WebSocket ws, int code, String reason, boolean remote) {
        }

        public void onWebsocketCloseInitiated(WebSocket ws, int code, String reason) {
        }

        public void onWebsocketError(WebSocket conn, Exception ex) {
        }

        public void onWriteDemand(WebSocket conn) {
        }

        public InetSocketAddress getLocalSocketAddress(WebSocket conn) {
            return null;
        }

        public InetSocketAddress getRemoteSocketAddress(WebSocket conn) {
            return null;
        }
    }
}

