/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.junit.Assert;
import org.junit.Test;

public class Issue765Test {
    boolean isClosedCalled = false;

    @Test
    public void testIssue() {
        MyWebSocketServer webSocketServer = new MyWebSocketServer();
        webSocketServer.setWebSocketFactory(new LocalWebSocketFactory());
        Assert.assertFalse((String)"Close should not have been called yet", (boolean)this.isClosedCalled);
        webSocketServer.setWebSocketFactory(new LocalWebSocketFactory());
        Assert.assertTrue((String)"Close has been called", (boolean)this.isClosedCalled);
    }

    private class LocalWebSocketFactory
    implements WebSocketServerFactory {
        private LocalWebSocketFactory() {
        }

        public WebSocketImpl createWebSocket(WebSocketAdapter a, Draft d) {
            return null;
        }

        public WebSocketImpl createWebSocket(WebSocketAdapter a, List<Draft> drafts) {
            return null;
        }

        public ByteChannel wrapChannel(SocketChannel channel, SelectionKey key) throws IOException {
            return null;
        }

        public void close() {
            Issue765Test.this.isClosedCalled = true;
        }
    }

    private static class MyWebSocketServer
    extends WebSocketServer {
        private MyWebSocketServer() {
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        }

        public void onMessage(WebSocket conn, String message) {
        }

        public void onError(WebSocket conn, Exception ex) {
        }

        public void onStart() {
        }
    }
}

