/*
 * Decompiled with CFR 0.152.
 */
package org.rxjava.security.example.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.UUID;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.rxjava.common.core.exception.ErrorMessageException;
import org.rxjava.common.core.utils.UUIDUtils;
import org.rxjava.security.example.entity.LoginLog;
import org.rxjava.security.example.entity.ManagerAuth;
import org.rxjava.security.example.entity.Permission;
import org.rxjava.security.example.entity.Role;
import org.rxjava.security.example.entity.SecurityUser;
import org.rxjava.security.example.form.LoginByPhoneSmsForm;
import org.rxjava.security.example.repository.LoginLogRepository;
import org.rxjava.security.example.repository.ManagerAuthRepository;
import org.rxjava.security.example.type.IdentityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Api(value="Swagger test Controller", description="learn how to use swagger")
@RestController
public class DemoController {
    private static final int TOKEN_LENGTH = 32;
    @Autowired
    private ReactiveRedisTemplate<String, String> reactiveRedisTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ManagerAuthRepository managerAuthRepository;
    @Autowired
    private LoginLogRepository loginLogRepository;

    @ApiOperation(value="\u624b\u673a\u9a8c\u8bc1\u7801\u767b\u9646\u63a5\u53e3")
    @PostMapping(value={"loginByPhoneSms"})
    public Mono<String> loginByPhoneSms(@Valid LoginByPhoneSmsForm form) {
        return this.managerAuthRepository.findByIdentityTypeAndIdentifier(IdentityType.PHONE.name(), form.getPhone()).switchIfEmpty(Mono.just((Object)new ManagerAuth()).flatMap(managerAuth -> {
            managerAuth.setIdentityType(IdentityType.PHONE.name());
            managerAuth.setIdentifier(form.getPhone());
            return this.managerAuthRepository.save(managerAuth);
        })).flatMap(managerAuth -> {
            String securityUserStr;
            String token = this.newToken();
            String managerId = managerAuth.getManagerId();
            SecurityUser securityUser = new SecurityUser(managerId, managerAuth.getId(), managerAuth.getIdentifier(), IdentityType.PHONE.name(), new ArrayList<Role>());
            try {
                securityUserStr = this.objectMapper.writeValueAsString((Object)securityUser);
            }
            catch (JsonProcessingException e) {
                throw ErrorMessageException.of((String)"\u767b\u9646\u4fe1\u606f\u89e3\u6790json\u9519\u8bef");
            }
            return this.reactiveRedisTemplate.opsForValue().set((Object)token, (Object)securityUserStr, Duration.ofMinutes(120L)).map(b -> token).doOnSuccess(tk -> {
                LoginLog loginLog = new LoginLog();
                loginLog.setIdentityType(managerAuth.getIdentityType());
                loginLog.setIdentifier(form.getPhone());
                loginLog.setManagerId(managerId);
                loginLog.setToken((String)tk);
                this.loginLogRepository.save(loginLog).subscribe();
            });
        });
    }

    @GetMapping(value={"info"})
    public Mono<String> getInfo() {
        return Mono.just((Object)UUID.randomUUID().toString());
    }

    private String newToken() {
        String uuid = UUIDUtils.randomUUIDToBase64();
        return uuid + RandomStringUtils.randomAlphanumeric((int)(32 - uuid.length()));
    }

    @GetMapping(value={"hasRole"})
    @PreAuthorize(value="hasRole('USER')")
    public Mono<String> hasRole() {
        return Mono.just((Object)UUID.randomUUID().toString());
    }

    @GetMapping(value={"hasAnyRole"})
    @PreAuthorize(value="hasAnyRole('USER','ADMIN')")
    public Mono<String> hasAnyRole() {
        return Mono.just((Object)UUID.randomUUID().toString());
    }

    @GetMapping(value={"hasPermission"})
    @PreAuthorize(value="hasPermission(#id,'edit')")
    public Mono<String> hasPermission(String id, Permission permission) {
        return Mono.just((Object)UUID.randomUUID().toString());
    }
}

