/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.audioengines;

import java.util.ArrayList;
import org.scijava.java3d.AudioDevice3D;
import org.scijava.java3d.MediaContainer;
import org.scijava.java3d.PhysicalEnvironment;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.View;
import org.scijava.java3d.audioengines.AudioEngine;
import org.scijava.java3d.audioengines.AuralParameters;
import org.scijava.java3d.audioengines.Sample;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Vector3d;

public abstract class AudioEngine3D
extends AudioEngine
implements AudioDevice3D {
    protected ArrayList samples = new ArrayList(64);
    protected View currentView = null;
    protected AuralParameters attribs = new AuralParameters();

    public AudioEngine3D(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    public void setView(View reference) {
        this.currentView = reference;
    }

    public View getView() {
        return this.currentView;
    }

    public int prepareSound(int soundType, MediaContainer soundData) {
        return -1;
    }

    public abstract void clearSound(int var1);

    public void setVworldXfrm(int index, Transform3D trans) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.vworldXfrm.set(trans);
        }
    }

    public abstract int startSample(int var1);

    public abstract int stopSample(int var1);

    public abstract void updateSample(int var1);

    public abstract void muteSample(int var1);

    public abstract void unmuteSample(int var1);

    public abstract void pauseSample(int var1);

    public abstract void unpauseSample(int var1);

    public void setSampleGain(int index, float scaleFactor) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setGain(scaleFactor);
        }
    }

    public void setLoop(int index, int count) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setLoopCount(count);
        }
    }

    public void setPosition(int index, Point3d position) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setPosition(position);
        }
    }

    public void setDistanceGain(int index, double[] frontDistance, float[] frontAttenuationScaleFactor, double[] backDistance, float[] backAttenuationScaleFactor) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setDistanceGain(frontDistance, frontAttenuationScaleFactor, backDistance, backAttenuationScaleFactor);
        }
    }

    public void setDirection(int index, Vector3d direction) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setDirection(direction);
        }
    }

    public void setAngularAttenuation(int index, int filterType, double[] angle, float[] attenuationScaleFactor, float[] filterCutoff) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            sample.setAngularAttenuation(filterType, angle, attenuationScaleFactor, filterCutoff);
        }
    }

    public void setRolloff(float rolloff) {
        this.attribs.rolloff = rolloff;
    }

    public void setReflectionCoefficient(float coefficient) {
        this.attribs.reflectionCoefficient = coefficient;
    }

    public void setReverbDelay(float reverbDelay) {
        this.attribs.reverbDelay = reverbDelay;
    }

    public void setReverbOrder(int reverbOrder) {
        this.attribs.reverbOrder = reverbOrder;
    }

    public void setDistanceFilter(int filterType, double[] dist, float[] filterCutoff) {
        this.attribs.setDistanceFilter(filterType, dist, filterCutoff);
    }

    public void setFrequencyScaleFactor(float scaleFactor) {
        this.attribs.frequencyScaleFactor = scaleFactor;
    }

    public void setVelocityScaleFactor(float scaleFactor) {
        this.attribs.velocityScaleFactor = scaleFactor;
    }

    public int getNumberOfChannelsUsed(int index) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    public int getNumberOfChannelsUsed(int index, boolean muteFlag) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getNumberOfChannelsUsed();
        }
        return 0;
    }

    public long getSampleDuration(int index) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getDuration();
        }
        return 0L;
    }

    public long getStartTime(int index) {
        Sample sample = this.getSample(index);
        if (sample != null) {
            return sample.getStartTime();
        }
        return 0L;
    }

    protected ArrayList getSampleList() {
        return this.samples;
    }

    public int getSampleListSize() {
        return this.samples.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sample getSample(int index) {
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            if (index >= 0 && index < this.samples.size()) {
                Sample sample = (Sample)this.samples.get(index);
                return sample;
            }
            return null;
        }
    }

    public AuralParameters getAuralParameters() {
        return this.attribs;
    }
}

