/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.pickfast;

import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Group;
import org.scijava.java3d.Link;
import org.scijava.java3d.Locale;
import org.scijava.java3d.Morph;
import org.scijava.java3d.Node;
import org.scijava.java3d.PickBounds;
import org.scijava.java3d.PickConeRay;
import org.scijava.java3d.PickConeSegment;
import org.scijava.java3d.PickCylinderRay;
import org.scijava.java3d.PickCylinderSegment;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickRay;
import org.scijava.java3d.PickSegment;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Switch;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.utils.geometry.Primitive;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Vector3d;

public class PickTool {
    public static final int TYPE_SHAPE3D = 1;
    public static final int TYPE_MORPH = 2;
    public static final int TYPE_PRIMITIVE = 4;
    public static final int TYPE_LINK = 8;
    public static final int TYPE_GROUP = 16;
    public static final int TYPE_TRANSFORM_GROUP = 32;
    public static final int TYPE_BRANCH_GROUP = 64;
    public static final int TYPE_SWITCH = 128;
    private static final int ALL_FLAGS = 127;
    private final boolean debug = false;
    protected boolean userDefineShape = false;
    PickShape pickShape;
    BranchGroup pickRootBG = null;
    Locale pickRootL = null;
    Point3d start = null;
    int mode = 1;
    int flags = 2;

    public PickTool(BranchGroup b) {
        this.pickRootBG = b;
    }

    public PickTool(Locale l) {
        this.pickRootL = l;
    }

    public BranchGroup getBranchGroup() {
        return this.pickRootBG;
    }

    public Locale getLocale() {
        return this.pickRootL;
    }

    public void setShape(PickShape ps, Point3d startPt) {
        this.pickShape = ps;
        this.start = startPt;
        this.userDefineShape = ps != null;
    }

    public void setShapeBounds(Bounds bounds, Point3d startPt) {
        this.pickShape = new PickBounds(bounds);
        this.start = startPt;
        this.userDefineShape = true;
    }

    public void setMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setFlags(int flags) {
        if ((flags & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException();
        }
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setShapeRay(Point3d start, Vector3d dir) {
        this.pickShape = new PickRay(start, dir);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeSegment(Point3d start, Point3d end) {
        this.pickShape = new PickSegment(start, end);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeCylinderSegment(Point3d start, Point3d end, double radius) {
        this.pickShape = new PickCylinderSegment(start, end, radius);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeCylinderRay(Point3d start, Vector3d dir, double radius) {
        this.pickShape = new PickCylinderRay(start, dir, radius);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeConeSegment(Point3d start, Point3d end, double angle) {
        this.pickShape = new PickConeSegment(start, end, angle);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeConeRay(Point3d start, Vector3d dir, double angle) {
        this.pickShape = new PickConeRay(start, dir, angle);
        this.start = start;
        this.userDefineShape = true;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public Point3d getStartPosition() {
        return this.start;
    }

    public PickInfo[] pickAll() {
        PickInfo[] pickInfos = null;
        if (this.pickRootBG != null) {
            pickInfos = this.pickRootBG.pickAll(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfos = this.pickRootL.pickAll(this.mode, this.flags, this.pickShape);
        }
        return pickInfos;
    }

    public PickInfo pickAny() {
        PickInfo pickInfo = null;
        if (this.pickRootBG != null) {
            pickInfo = this.pickRootBG.pickAny(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfo = this.pickRootL.pickAny(this.mode, this.flags, this.pickShape);
        }
        return pickInfo;
    }

    public PickInfo[] pickAllSorted() {
        PickInfo[] pickInfos = null;
        if (this.pickRootBG != null) {
            pickInfos = this.pickRootBG.pickAllSorted(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfos = this.pickRootL.pickAllSorted(this.mode, this.flags, this.pickShape);
        }
        return pickInfos;
    }

    public PickInfo pickClosest() {
        PickInfo pickInfo = null;
        if (this.pickRootBG != null) {
            pickInfo = this.pickRootBG.pickClosest(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfo = this.pickRootL.pickClosest(this.mode, this.flags, this.pickShape);
        }
        return pickInfo;
    }

    public Node getNode(PickInfo pickInfo, int type) {
        if (pickInfo == null) {
            return null;
        }
        SceneGraphPath sgp = pickInfo.getSceneGraphPath();
        Node pickedNode = pickInfo.getNode();
        if (pickedNode instanceof Shape3D && (type & 1) != 0) {
            return pickedNode;
        }
        if (pickedNode instanceof Morph && (type & 2) != 0) {
            return pickedNode;
        }
        for (int j = sgp.nodeCount() - 1; j >= 0; --j) {
            Node pNode = sgp.getNode(j);
            if (pNode instanceof Primitive && (type & 4) != 0) {
                return pNode;
            }
            if (pNode instanceof Link && (type & 8) != 0) {
                return pNode;
            }
            if (pNode instanceof Switch && (type & 0x80) != 0) {
                return pNode;
            }
            if (pNode instanceof TransformGroup && (type & 0x20) != 0) {
                return pNode;
            }
            if (pNode instanceof BranchGroup && (type & 0x40) != 0) {
                return pNode;
            }
            if (!(pNode instanceof Group) || (type & 0x10) == 0) continue;
            return pNode;
        }
        return null;
    }
}

