/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.util.LinkedList;
import org.scijava.console.ConsoleArgument;
import org.scijava.console.ConsoleService;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultConsoleService
extends AbstractHandlerService<LinkedList<String>, ConsoleArgument>
implements ConsoleService {
    @Parameter
    private LogService log;

    @Override
    public void processArgs(String ... args) {
        this.log.debug("Received command line arguments:");
        LinkedList<String> argList = new LinkedList<String>();
        for (String arg : args) {
            this.log.debug("\t" + arg);
            argList.add(arg);
        }
        while (!argList.isEmpty()) {
            ConsoleArgument handler = (ConsoleArgument)this.getHandler(argList);
            if (handler == null) {
                String arg = (String)argList.removeFirst();
                this.log.warn("Ignoring invalid argument: " + arg);
                continue;
            }
            handler.handle(argList);
        }
    }

    @Override
    public Class<ConsoleArgument> getPluginType() {
        return ConsoleArgument.class;
    }

    @Override
    public Class<LinkedList<String>> getType() {
        return LinkedList.class;
    }
}

