/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.MenuPath;
import org.scijava.plugin.Plugin;
import org.scijava.script.AbstractScriptLanguage;
import org.scijava.script.ScriptFinder;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.test.TestUtils;
import org.scijava.util.AppUtils;
import org.scijava.util.FileUtils;

public class ScriptFinderTest {
    private static File scriptsDir;

    @BeforeClass
    public static void setUp() throws IOException {
        String[] scriptPaths;
        scriptsDir = TestUtils.createTemporaryDirectory((String)"script-finder-");
        for (String scriptPath : scriptPaths = new String[]{"ignored.foo", "Scripts/quick.foo", "Scripts/brown.foo", "Scripts/fox.foo", "Scripts/The_Lazy_Dog.foo", "Math/add.foo", "Math/subtract.foo", "Math/multiply.foo", "Math/divide.foo", "Math/Trig/cos.foo", "Math/Trig/sin.foo", "Math/Trig/tan.foo"}) {
            TestUtils.createPath((File)scriptsDir, (String)scriptPath);
        }
    }

    @AfterClass
    public static void tearDown() {
        FileUtils.deleteRecursively((File)scriptsDir);
    }

    @Test
    public void testFindScripts() {
        ScriptService scriptService = this.createScriptService();
        scriptService.addScriptDirectory(scriptsDir);
        ArrayList<ScriptInfo> scripts = this.findScripts(scriptService);
        String[] expected = new String[]{"Scripts > The Lazy Dog", "Math > add", "Scripts > brown", "Math > Trig > cos", "Math > divide", "Scripts > fox", "Math > multiply", "Math > pow", "Scripts > quick", "Math > Trig > sin", "Math > subtract", "Math > Trig > tan"};
        this.assertMenuPaths(expected, scripts);
    }

    @Test
    public void testMenuPrefixes() {
        ScriptService scriptService = this.createScriptService();
        MenuPath menuPrefix = new MenuPath("Foo > Bar");
        Assert.assertEquals((long)2L, (long)menuPrefix.size());
        Assert.assertEquals((Object)"Bar", (Object)menuPrefix.getLeaf().getName());
        scriptService.addScriptDirectory(scriptsDir, menuPrefix);
        ArrayList<ScriptInfo> scripts = this.findScripts(scriptService);
        String[] expected = new String[]{"Foo > Bar > Scripts > The Lazy Dog", "Foo > Bar > Math > add", "Foo > Bar > Scripts > brown", "Foo > Bar > Math > Trig > cos", "Foo > Bar > Math > divide", "Foo > Bar > Scripts > fox", "Foo > Bar > ignored", "Foo > Bar > Math > multiply", "Math > pow", "Foo > Bar > Scripts > quick", "Foo > Bar > Math > Trig > sin", "Foo > Bar > Math > subtract", "Foo > Bar > Math > Trig > tan"};
        this.assertMenuPaths(expected, scripts);
    }

    @Test
    public void testOverlappingDirectories() {
        ScriptService scriptService = this.createScriptService();
        scriptService.addScriptDirectory(new File(scriptsDir, "Scripts"), new MenuPath("Plugins"));
        scriptService.addScriptDirectory(scriptsDir);
        ArrayList<ScriptInfo> scripts = this.findScripts(scriptService);
        String[] expected = new String[]{"Plugins > The Lazy Dog", "Math > add", "Plugins > brown", "Math > Trig > cos", "Math > divide", "Plugins > fox", "Math > multiply", "Math > pow", "Plugins > quick", "Math > Trig > sin", "Math > subtract", "Math > Trig > tan"};
        this.assertMenuPaths(expected, scripts);
    }

    private ScriptService createScriptService() {
        Context context = new Context(new Class[]{ScriptService.class});
        ScriptService scriptService = (ScriptService)context.service(ScriptService.class);
        File defaultScriptsDir = new File(AppUtils.getBaseDirectory(ScriptFinder.class), "scripts");
        scriptService.removeScriptDirectory(defaultScriptsDir);
        return scriptService;
    }

    private ArrayList<ScriptInfo> findScripts(ScriptService scriptService) {
        ScriptFinder scriptFinder = new ScriptFinder(scriptService.context());
        ArrayList<ScriptInfo> scripts = new ArrayList<ScriptInfo>();
        scriptFinder.findScripts(scripts);
        Collections.sort(scripts);
        return scripts;
    }

    private void assertMenuPaths(String[] expected, ArrayList<ScriptInfo> scripts) {
        Assert.assertEquals((long)expected.length, (long)scripts.size());
        for (int i = 0; i < expected.length; ++i) {
            String actual = scripts.get(i).getMenuPath().getMenuString();
            Assert.assertEquals((Object)expected[i], (Object)actual);
        }
    }

    @Plugin(type=ScriptLanguage.class)
    public static class FooScriptLanguage
    extends AbstractScriptLanguage {
        public List<String> getExtensions() {
            return Arrays.asList("foo");
        }

        public ScriptEngine getScriptEngine() {
            throw new IllegalStateException();
        }
    }
}

