/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.scijava.io.DataHandleInputStream;
import org.scijava.io.Location;
import org.scijava.plugin.WrapperPlugin;

public interface DataHandle<L extends Location>
extends WrapperPlugin<L>,
DataInput,
DataOutput,
Closeable {
    public static final int DEFAULT_BLOCK_SIZE = 262144;
    public static final int MAX_SEARCH_SIZE = 0x20000000;

    public long offset() throws IOException;

    public long length() throws IOException;

    public ByteOrder getOrder();

    default public boolean isLittleEndian() {
        return this.getOrder() == ByteOrder.LITTLE_ENDIAN;
    }

    public void setOrder(ByteOrder var1);

    default public void setOrder(boolean little) {
        this.setOrder(little ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    public String getEncoding();

    public void setEncoding(String var1);

    default public int read(ByteBuffer buf) throws IOException {
        return this.read(buf, buf.remaining());
    }

    default public int read(ByteBuffer buf, int len) throws IOException {
        int n;
        if (buf.hasArray()) {
            n = this.read(buf.array(), buf.arrayOffset(), len);
        } else {
            byte[] b = new byte[len];
            n = this.read(b);
            buf.put(b, 0, n);
        }
        return n;
    }

    public void seek(long var1) throws IOException;

    default public void write(ByteBuffer buf) throws IOException {
        this.write(buf, buf.remaining());
    }

    default public void write(ByteBuffer buf, int len) throws IOException {
        if (buf.hasArray()) {
            this.write(buf.array(), buf.arrayOffset(), len);
        } else {
            byte[] b = new byte[len];
            buf.get(b);
            this.write(b);
        }
    }

    default public String readCString() throws IOException {
        String line = this.findString("\u0000");
        return line.length() == 0 ? null : line;
    }

    default public String readString(int n) throws IOException {
        long avail = this.length() - this.offset();
        if ((long)n > avail) {
            n = (int)avail;
        }
        byte[] b = new byte[n];
        this.readFully(b);
        return new String(b, this.getEncoding());
    }

    default public String readString(String lastChars) throws IOException {
        if (lastChars.length() == 1) {
            return this.findString(lastChars);
        }
        String[] terminators = new String[lastChars.length()];
        for (int i = 0; i < terminators.length; ++i) {
            terminators[i] = lastChars.substring(i, i + 1);
        }
        return this.findString(terminators);
    }

    default public String findString(String ... terminators) throws IOException {
        return this.findString(true, 262144, terminators);
    }

    default public String findString(boolean saveString, String ... terminators) throws IOException {
        return this.findString(saveString, 262144, terminators);
    }

    default public String findString(int blockSize, String ... terminators) throws IOException {
        return this.findString(true, blockSize, terminators);
    }

    default public String findString(boolean saveString, int blockSize, String ... terminators) throws IOException {
        int r;
        boolean tooLong;
        StringBuilder out = new StringBuilder();
        long startPos = this.offset();
        long bytesDropped = 0L;
        long inputLen = this.length();
        long maxLen = inputLen - startPos;
        boolean bl = tooLong = saveString && maxLen > 0x20000000L;
        if (tooLong) {
            maxLen = 0x20000000L;
        }
        boolean match = false;
        int maxTermLen = 0;
        for (String term : terminators) {
            int len = term.length();
            if (len <= maxTermLen) continue;
            maxTermLen = len;
        }
        InputStreamReader in = new InputStreamReader(new DataHandleInputStream(this), this.getEncoding());
        char[] buf = new char[blockSize];
        for (long loc = 0L; loc < maxLen && this.offset() < this.length() - 1L; loc += (long)r) {
            int outLen;
            if (!saveString && (outLen = out.length()) >= maxTermLen) {
                int dropIndex = outLen - maxTermLen + 1;
                String last = out.substring(dropIndex, outLen);
                out.setLength(0);
                out.append(last);
                bytesDropped += (long)dropIndex;
            }
            if ((r = in.read(buf, 0, blockSize)) <= 0) {
                throw new IOException("Cannot read from stream: " + r);
            }
            out.append(buf, 0, r);
            int min = Integer.MAX_VALUE;
            int tagLen = 0;
            String[] stringArray = terminators;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String t;
                int len = (t = stringArray[i]).length();
                int start = (int)(loc - bytesDropped - (long)len);
                int value = out.indexOf(t, start < 0 ? 0 : start);
                if (value < 0 || value >= min) continue;
                match = true;
                min = value;
                tagLen = len;
            }
            if (!match) continue;
            this.seek(startPos + bytesDropped + (long)min + (long)tagLen);
            if (saveString) {
                out.setLength(min + tagLen);
                return out.toString();
            }
            return null;
        }
        if (tooLong) {
            throw new IOException("Maximum search length reached.");
        }
        return saveString ? out.toString() : null;
    }

    public int read() throws IOException;

    default public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] var1, int var2, int var3) throws IOException;

    default public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        long remain = this.length() - this.offset();
        long num = n < remain ? n : remain;
        this.seek(this.offset() + num);
        return num;
    }
}

