/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.scijava.util.Manifest;
import org.scijava.util.POM;

public class VersionUtils {
    public static String getVersion(Class<?> c) {
        return VersionUtils.getVersion(c, null, null);
    }

    public static String getVersion(Class<?> c, String groupId, String artifactId) {
        String version = VersionUtils.getVersionFromManifest(c);
        if (version != null) {
            return version;
        }
        return VersionUtils.getVersionFromPOM(c, groupId, artifactId);
    }

    public static String getVersionFromManifest(Class<?> c) {
        Manifest m = Manifest.getManifest(c);
        return m == null ? null : m.getVersion();
    }

    public static String getVersionFromPOM(Class<?> c, String groupId, String artifactId) {
        POM pom = POM.getPOM(c, groupId, artifactId);
        return pom == null ? null : pom.getVersion();
    }

    public static String getBuildNumber(Class<?> c) {
        Manifest m = Manifest.getManifest(c);
        return m == null ? null : m.getImplementationBuild();
    }

    public static int compare(String v1, String v2) {
        String[] t1 = VersionUtils.splitDots(v1);
        String[] t2 = VersionUtils.splitDots(v2);
        int count = Math.min(t1.length, t2.length);
        for (int t = 0; t < count; ++t) {
            int c = VersionUtils.compareToken(t1[t], t2[t]);
            if (c == 0) continue;
            return c;
        }
        if (t1.length == t2.length) {
            return 0;
        }
        return t1.length < t2.length ? -1 : 1;
    }

    private static String[] splitDots(String s) {
        return s.isEmpty() ? new String[]{} : s.split("\\.", -1);
    }

    private static int compareToken(String t1, String t2) {
        int i1 = VersionUtils.digitIndex(t1);
        int i2 = VersionUtils.digitIndex(t2);
        if (i1 > 0 && i2 > 0) {
            long d2;
            long d1 = Long.parseLong(t1.substring(0, i1));
            if (d1 < (d2 = Long.parseLong(t2.substring(0, i2)))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
        }
        return t1.substring(i1).compareTo(t2.substring(i2));
    }

    private static int digitIndex(String s) {
        char ch;
        int index = 0;
        for (int i = 0; i < s.length() && (ch = s.charAt(index)) >= '0' && ch <= '9'; ++i) {
            ++index;
        }
        return index;
    }
}

