/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.prefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.prefs.PrefService;

public class PrefServiceTest {
    private PrefService prefService;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{PrefService.class});
        this.prefService = (PrefService)context.getService(PrefService.class);
    }

    @After
    public void tearDown() {
        this.prefService.clear(this.getClass());
        this.prefService.getContext().dispose();
    }

    @Test
    public void testString() {
        Assert.assertNull((Object)this.prefService.get(this.getClass(), "animal"));
        this.prefService.put(this.getClass(), "animal", "kraken");
        Assert.assertEquals((Object)"kraken", (Object)this.prefService.get(this.getClass(), "animal"));
    }

    @Test
    public void testBoolean() {
        Assert.assertFalse((boolean)this.prefService.getBoolean(this.getClass(), "awesome", false));
        this.prefService.put(this.getClass(), "awesome", true);
        Assert.assertTrue((boolean)this.prefService.getBoolean(this.getClass(), "awesome", false));
    }

    @Test
    public void testDouble() {
        String key = "real";
        double dv = 0.0;
        double value = 123.456;
        Assert.assertEquals((double)0.0, (double)this.prefService.getDouble(this.getClass(), "real", 0.0), (double)0.0);
        this.prefService.put(this.getClass(), "real", 123.456);
        Assert.assertEquals((double)123.456, (double)this.prefService.getDouble(this.getClass(), "real", 0.0), (double)0.0);
    }

    @Test
    public void testFloat() {
        String key = "real";
        float dv = 0.0f;
        float value = 654.321f;
        Assert.assertEquals((float)0.0f, (float)this.prefService.getFloat(this.getClass(), "real", 0.0f), (float)0.0f);
        this.prefService.put(this.getClass(), "real", 654.321f);
        Assert.assertEquals((float)654.321f, (float)this.prefService.getFloat(this.getClass(), "real", 0.0f), (float)0.0f);
    }

    @Test
    public void testInt() {
        String key = "integer";
        boolean dv = false;
        int value = 1234;
        Assert.assertEquals((long)0L, (long)this.prefService.getInt(this.getClass(), "integer", 0));
        this.prefService.put(this.getClass(), "integer", 1234);
        Assert.assertEquals((long)1234L, (long)this.prefService.getInt(this.getClass(), "integer", 0));
    }

    @Test
    public void testLong() {
        long dv = 0L;
        long value = 9999999999999L;
        Assert.assertEquals((long)0L, (long)this.prefService.getLong(this.getClass(), "power level", 0L));
        this.prefService.put(this.getClass(), "power level", 9999999999999L);
        Assert.assertTrue((this.prefService.getLong(this.getClass(), "power level", 0L) > 9000L ? 1 : 0) != 0);
    }

    @Test
    public void testMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", "A");
        map.put("1", "B");
        map.put("2", "C");
        map.put("3", "D");
        map.put("5", "f");
        String mapName = "MapKey";
        this.prefService.put(this.getClass(), "MapKey", map);
        Map result = this.prefService.getMap(this.getClass(), "MapKey");
        Assert.assertEquals(map, (Object)result);
    }

    @Test
    public void testList() {
        String recentFilesName = "RecentFiles";
        ArrayList<String> recentFiles = new ArrayList<String>();
        recentFiles.add("some/path1");
        recentFiles.add("some/path2");
        recentFiles.add("some/path3");
        this.prefService.put(this.getClass(), "RecentFiles", recentFiles);
        List result = this.prefService.getList(this.getClass(), "RecentFiles");
        Assert.assertEquals(recentFiles, (Object)result);
    }

    @Test
    public void testClear() {
        this.prefService.put(this.getClass(), "dog", "lazy");
        this.prefService.put(this.getClass(), "fox", "quick");
        Assert.assertEquals((Object)"lazy", (Object)this.prefService.get(this.getClass(), "dog"));
        Assert.assertEquals((Object)"quick", (Object)this.prefService.get(this.getClass(), "fox"));
        this.prefService.clear(this.getClass());
        Assert.assertNull((Object)this.prefService.get(this.getClass(), "dog"));
        Assert.assertNull((Object)this.prefService.get(this.getClass(), "fox"));
    }

    @Test
    public void testRemove() {
        this.prefService.put(this.getClass(), "hello", "world");
        Assert.assertEquals((Object)"world", (Object)this.prefService.get(this.getClass(), "hello"));
        this.prefService.remove(this.getClass(), "hello");
        Assert.assertNull((Object)this.prefService.get(this.getClass(), "hello"));
    }

    @Test
    public void testLongKeys() {
        String longKey = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567899876543210ZYXWVUTSRQPONMLKJIHGFEDCBAzyxwvutsrqponmlkjihgfedcba";
        String lyrics = "Now I know my ABC's. Next time won't you sing with me?";
        this.prefService.put(this.getClass(), "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567899876543210ZYXWVUTSRQPONMLKJIHGFEDCBAzyxwvutsrqponmlkjihgfedcba", "Now I know my ABC's. Next time won't you sing with me?");
        String recovered = this.prefService.get(this.getClass(), "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567899876543210ZYXWVUTSRQPONMLKJIHGFEDCBAzyxwvutsrqponmlkjihgfedcba");
        Assert.assertEquals((Object)"Now I know my ABC's. Next time won't you sing with me?", (Object)recovered);
    }

    @Test
    public void testClassesInSamePackage() {
        String blueDog = "lazy";
        String blueFox = "quick";
        String redDog = "friendly";
        String redCat = "snuggly";
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "cat"));
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "fox"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "cat"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "fox"));
        this.prefService.put(BlueNode.class, "dog", "lazy");
        this.prefService.put(BlueNode.class, "fox", "quick");
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "cat"));
        Assert.assertEquals((Object)"lazy", (Object)this.prefService.get(BlueNode.class, "dog"));
        Assert.assertEquals((Object)"quick", (Object)this.prefService.get(BlueNode.class, "fox"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "cat"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "fox"));
        this.prefService.put(RedNode.class, "dog", "friendly");
        this.prefService.put(RedNode.class, "cat", "snuggly");
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "cat"));
        Assert.assertEquals((Object)"lazy", (Object)this.prefService.get(BlueNode.class, "dog"));
        Assert.assertEquals((Object)"quick", (Object)this.prefService.get(BlueNode.class, "fox"));
        Assert.assertEquals((Object)"snuggly", (Object)this.prefService.get(RedNode.class, "cat"));
        Assert.assertEquals((Object)"friendly", (Object)this.prefService.get(RedNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "fox"));
        this.prefService.clear(BlueNode.class);
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "cat"));
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "fox"));
        Assert.assertEquals((Object)"snuggly", (Object)this.prefService.get(RedNode.class, "cat"));
        Assert.assertEquals((Object)"friendly", (Object)this.prefService.get(RedNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "fox"));
        this.prefService.clear(RedNode.class);
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "cat"));
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(BlueNode.class, "fox"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "cat"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "dog"));
        Assert.assertNull((Object)this.prefService.get(RedNode.class, "fox"));
    }

    private static interface RedNode {
    }

    private static interface BlueNode {
    }
}

