/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import org.scijava.log.IgnoreAsCallingClass;

@IgnoreAsCallingClass
public final class CallingClassUtils {
    private CallingClassUtils() {
    }

    public static Class<?> getCallingClass() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stackTrace.length - 1; ++i) {
                Class<?> clazz = Class.forName(stackTrace[i].getClassName());
                if (clazz.isAnnotationPresent(IgnoreAsCallingClass.class)) continue;
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new IllegalStateException();
    }
}

