/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import java.net.URISyntaxException;
import org.scijava.io.IOPlugin;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.AbstractHandlerPlugin;
import org.scijava.plugin.Parameter;

public abstract class AbstractIOPlugin<D>
extends AbstractHandlerPlugin<Location>
implements IOPlugin<D> {
    @Parameter
    private LocationService locationService;

    @Override
    public boolean supportsOpen(String source) {
        try {
            return this.supportsOpen(this.locationService.resolve(source));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public boolean supportsSave(String destination) {
        try {
            return this.supportsSave(this.locationService.resolve(destination));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public void save(D data, String destination) throws IOException {
        try {
            this.save(data, this.locationService.resolve(destination));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public D open(String destination) throws IOException {
        try {
            return this.open(this.locationService.resolve(destination));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

