/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import java.net.URISyntaxException;
import org.scijava.io.IOPlugin;
import org.scijava.io.IOService;
import org.scijava.io.TypedIOService;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;

public abstract class AbstractTypedIOService<D>
extends AbstractHandlerService<Location, IOPlugin<D>>
implements TypedIOService<D> {
    @Parameter
    private LocationService locationService;
    @Parameter
    private IOService ioService;

    @Override
    public D open(String source) throws IOException {
        try {
            return this.open(this.locationService.resolve(source));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public D open(Location source) throws IOException {
        IOPlugin<?> opener = this.ioService().getOpener(source);
        try {
            Class<?> ignored = opener.getDataType();
            return (D)opener.open(source);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("No compatible opener found.");
        }
    }

    @Override
    public void save(D data, String destination) throws IOException {
        try {
            this.save(data, this.locationService.resolve(destination));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void save(D data, Location destination) throws IOException {
        IOPlugin<D> saver = this.ioService().getSaver(data, destination);
        if (saver == null) {
            throw new UnsupportedOperationException("No compatible saver found.");
        }
        saver.save(data, destination);
    }

    @Override
    public boolean canOpen(String source) {
        try {
            return this.canOpen(this.locationService.resolve(source));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public boolean canOpen(Location source) {
        IOPlugin<?> opener = this.ioService().getOpener(source);
        if (opener == null) {
            return false;
        }
        try {
            Class<?> ignored = opener.getDataType();
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean canSave(D data, String source) {
        try {
            return this.canSave(data, this.locationService.resolve(source));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public boolean canSave(D data, Location destination) {
        IOPlugin<D> saver = this.ioService.getSaver(data, destination);
        if (saver == null) {
            return false;
        }
        return saver.supportsSave(destination);
    }

    protected LocationService locationService() {
        return this.locationService;
    }

    protected IOService ioService() {
        return this.ioService;
    }
}

