/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class PropertiesHelper {
    public static Map<String, String> get(File filename) {
        HashMap<String, String> map = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("=", 2);
                if (parts.length != 2) continue;
                map.put(parts[0], parts[1]);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static void put(Map<String, String> properties, File filename) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                writer.write(entry.getKey() + "=" + entry.getValue());
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

