/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.sjep.SubSequence;

public class SubSequenceTest {
    private static String PHRASE = "The quick brown fox jumped over the lazy dogs.";

    @Test
    public void testLength() {
        for (int off = 0; off < PHRASE.length(); ++off) {
            for (int len = 0; len < PHRASE.length() - off; ++len) {
                Assert.assertEquals((long)len, (long)this.sub(off, len).length());
            }
        }
    }

    @Test
    public void testCharAt() {
        for (int off = 0; off < PHRASE.length(); ++off) {
            for (int len = 0; len < PHRASE.length() - off; ++len) {
                SubSequence sub = this.sub(off, len);
                for (int c = 0; c < sub.length(); ++c) {
                    Assert.assertEquals((long)PHRASE.charAt(off + c), (long)sub.charAt(c));
                }
            }
        }
    }

    @Test
    public void testSubSequence() {
        SubSequence sub = this.sub(4, 15);
        SubSequence subSub = sub.subSequence(6, 11);
        Assert.assertEquals((long)5L, (long)subSub.length());
        Assert.assertEquals((long)98L, (long)subSub.charAt(0));
        Assert.assertEquals((long)114L, (long)subSub.charAt(1));
        Assert.assertEquals((long)111L, (long)subSub.charAt(2));
        Assert.assertEquals((long)119L, (long)subSub.charAt(3));
        Assert.assertEquals((long)110L, (long)subSub.charAt(4));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"quick brown fox", (Object)this.sub(4, 15).toString());
    }

    @Test
    public void testNegativeOffset() {
        try {
            this.sub(-1, 1);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException exc) {
            Assert.assertEquals((Object)"Offset -1 < 0", (Object)exc.getMessage());
        }
    }

    @Test
    public void testNegativeLength() {
        try {
            this.sub(1, -1);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException exc) {
            Assert.assertEquals((Object)"Length -1 < 0", (Object)exc.getMessage());
        }
    }

    @Test
    public void testOffsetTooLarge() {
        int len = PHRASE.length();
        int off = len + 1;
        try {
            this.sub(off, 1);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException exc) {
            Assert.assertEquals((Object)("Offset " + off + " > " + len), (Object)exc.getMessage());
        }
    }

    @Test
    public void testLengthTooLong() {
        int len = PHRASE.length();
        try {
            this.sub(1, len);
            Assert.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException exc) {
            Assert.assertEquals((Object)("Offset 1 + length " + len + " > " + len), (Object)exc.getMessage());
        }
    }

    private SubSequence sub(int offset, int length) {
        return new SubSequence((CharSequence)PHRASE, offset, length);
    }
}

