/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.meta;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.scijava.common3.Classes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XML {
    private final String path;
    private final Document doc;
    private final XPath xpath;
    private final boolean debug = "debug".equals(System.getProperty("scijava.log.level"));

    public XML(File file) throws IOException {
        this(file.getAbsolutePath(), XML.loadXML(file));
    }

    public XML(URL url) throws IOException {
        this(url.getPath(), XML.loadXML(url));
    }

    public XML(InputStream in) throws IOException {
        this(null, XML.loadXML(in));
    }

    public XML(String s) throws IOException {
        this(null, XML.loadXML(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XML(String path, Document doc) {
        this.path = path;
        this.doc = doc;
        if (this.debug) {
            System.err.println(Classes.location(XPathFactory.class));
        }
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        try {
            XPath xp;
            ClassLoader loader = contextClassLoader;
            while (true) {
                try {
                    xp = XPathFactory.newInstance().newXPath();
                    try {
                        xp.evaluate("//dummy", doc);
                    }
                    catch (Throwable t) {
                        if (this.debug) {
                            System.err.println("There was a problem with " + xp.getClass() + " in " + Classes.location(xp.getClass()) + ":");
                            t.printStackTrace();
                        }
                        throw new Error(t);
                    }
                }
                catch (Error e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    if (loader == null) {
                        throw e;
                    }
                    if ((loader = loader.getParent()) == null) {
                        throw e;
                    }
                    thread.setContextClassLoader(loader);
                    continue;
                }
                break;
            }
            this.xpath = xp;
        }
        finally {
            if (contextClassLoader != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public String path() {
        return this.path;
    }

    public String cdata(String expression) {
        NodeList nodes = this.xpath(expression);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return XML.cdata(nodes.item(0));
    }

    public String toString() {
        try {
            return XML.dumpXML(this.doc);
        }
        catch (TransformerException exc) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            exc.printStackTrace(new PrintStream(out));
            return out.toString();
        }
    }

    private static String cdata(Node item) {
        NodeList children = item.getChildNodes();
        if (children.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    private static Document loadXML(File file) throws IOException {
        try {
            return XML.createBuilder().parse(file.getAbsolutePath());
        }
        catch (ParserConfigurationException | SAXException exc) {
            throw new IOException(exc);
        }
    }

    private static Document loadXML(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            Document document = XML.loadXML(in);
            return document;
        }
    }

    private static Document loadXML(InputStream in) throws IOException {
        try {
            return XML.createBuilder().parse(in);
        }
        catch (ParserConfigurationException | SAXException exc) {
            throw new IOException(exc);
        }
    }

    private static Document loadXML(String s) throws IOException {
        try {
            return XML.createBuilder().parse(new ByteArrayInputStream(s.getBytes()));
        }
        catch (ParserConfigurationException | SAXException exc) {
            throw new IOException(exc);
        }
    }

    private static DocumentBuilder createBuilder() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    private static String dumpXML(Document doc) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }

    private NodeList xpath(String expression) {
        Object result;
        try {
            result = this.xpath.evaluate(expression, this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            return null;
        }
        return (NodeList)result;
    }
}

