/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInfo;
import org.scijava.priority.Prioritized;

public interface InfoTreeGenerator
extends Prioritized<InfoTreeGenerator> {
    public InfoTree generate(OpEnvironment var1, String var2, Map<String, OpInfo> var3, Collection<InfoTreeGenerator> var4);

    public static InfoTreeGenerator findSuitableGenerator(String signature, Collection<InfoTreeGenerator> generators) {
        List suitableGenerators = generators.stream().filter(g -> g.canGenerate(signature)).sorted().collect(Collectors.toList());
        if (suitableGenerators.isEmpty()) {
            throw new IllegalArgumentException("No InfoTreeGenerator in given collection " + generators + " is able to reify signature " + signature);
        }
        return (InfoTreeGenerator)suitableGenerators.get(0);
    }

    public static InfoTree generateDependencyTree(OpEnvironment env, String subsignature, Map<String, OpInfo> idMap, Collection<InfoTreeGenerator> generators) {
        InfoTreeGenerator genOpt = InfoTreeGenerator.findSuitableGenerator(subsignature, generators);
        return genOpt.generate(env, subsignature, idMap, generators);
    }

    public static String subSignatureFrom(String signature, int start) {
        int depsStart = signature.indexOf(InfoTree.DEP_START_DELIM.charValue(), start);
        int depth = 0;
        for (int i = depsStart; i < signature.length(); ++i) {
            char ch = signature.charAt(i);
            if (ch == InfoTree.DEP_START_DELIM.charValue()) {
                ++depth;
                continue;
            }
            if (ch != InfoTree.DEP_END_DELIM.charValue() || --depth != 0) continue;
            return signature.substring(start, i + 1);
        }
        throw new IllegalArgumentException("There is no complete signature starting from index " + start + " in signature " + signature);
    }

    public boolean canGenerate(String var1);

    default public double priority() {
        return 0.0;
    }
}

