/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.struct;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ops.engine.exceptions.impl.NullablesOnMultipleMethodsException;
import org.scijava.ops.engine.struct.FunctionalMethodType;
import org.scijava.ops.engine.struct.FunctionalParameters;
import org.scijava.ops.engine.struct.ParameterData;
import org.scijava.ops.engine.struct.SynthesizedParameterMember;
import org.scijava.ops.spi.OpDependency;
import org.scijava.struct.ItemIO;

public class SynthesizedMethodParameterData
implements ParameterData {
    private final Method m;
    private final Class<?> opType;

    public SynthesizedMethodParameterData(Method m, Class<?> opType) {
        this.m = m;
        this.opType = opType;
    }

    private List<String> getParameterNames(List<FunctionalMethodType> fmts) {
        ArrayList<String> fmtNames = new ArrayList<String>(fmts.size());
        int mutables = 1;
        int containers = 1;
        int outs = 1;
        int ins = 1;
        block6: for (FunctionalMethodType fmt : fmts) {
            switch (fmt.itemIO()) {
                case INPUT: {
                    fmtNames.add("input" + ins++);
                    continue block6;
                }
                case OUTPUT: {
                    fmtNames.add("output" + outs++);
                    continue block6;
                }
                case CONTAINER: {
                    fmtNames.add("container" + containers++);
                    continue block6;
                }
                case MUTABLE: {
                    fmtNames.add("mutable" + mutables++);
                    continue block6;
                }
            }
            throw new RuntimeException("Unexpected ItemIO type encountered!");
        }
        return fmtNames;
    }

    @Override
    public List<SynthesizedParameterMember<?>> synthesizeMembers(List<FunctionalMethodType> fmts) {
        Boolean[] optionality = SynthesizedMethodParameterData.getParameterNullability(this.m, this.opType, this.m.getParameterCount());
        List<String> names = this.getParameterNames(fmts);
        int p = 0;
        ArrayList members = new ArrayList(fmts.size());
        for (FunctionalMethodType fmt : fmts) {
            String name = names.get(p);
            boolean optional = fmt.itemIO() != ItemIO.OUTPUT && optionality[p++] != false;
            members.add(new SynthesizedParameterMember(fmt, name, !optional, ""));
        }
        return members;
    }

    private static Boolean[] getParameterNullability(Method m, Class<?> opType, int opParams) {
        boolean opMethodHasNullables = FunctionalParameters.hasNullableAnnotations(m);
        List<Method> fMethodsWithNullables = FunctionalParameters.fMethodsWithNullable(opType);
        if (opMethodHasNullables) {
            fMethodsWithNullables.add(m);
        }
        if (fMethodsWithNullables.size() > 1) {
            throw new NullablesOnMultipleMethodsException(m, fMethodsWithNullables);
        }
        if (opMethodHasNullables) {
            return SynthesizedMethodParameterData.getOpMethodNullables(m, opParams);
        }
        if (!fMethodsWithNullables.isEmpty()) {
            return FunctionalParameters.findParameterNullability(fMethodsWithNullables.get(0));
        }
        return FunctionalParameters.generateAllRequiredArray(opParams);
    }

    private static Boolean[] getOpMethodNullables(Method m, int opParams) {
        int[] paramIndex = SynthesizedMethodParameterData.mapFunctionalParamsToIndices(m.getParameters());
        Boolean[] arr = FunctionalParameters.generateAllRequiredArray(opParams);
        Boolean[] mNullables = FunctionalParameters.findParameterNullability(m);
        for (int i = 0; i < mNullables.length; ++i) {
            int index = paramIndex[i];
            if (index == -1) continue;
            Boolean[] booleanArray = arr;
            int n = index;
            Boolean.valueOf(booleanArray[n] | mNullables[i]);
        }
        return arr;
    }

    private static int[] mapFunctionalParamsToIndices(Parameter[] parameters) {
        int[] paramNo = new int[parameters.length];
        int paramIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            paramNo[i] = parameters[i].isAnnotationPresent(OpDependency.class) ? -1 : paramIndex++;
        }
        return paramNo;
    }
}

