/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.tutorial;

import java.util.Arrays;
import java.util.function.Function;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.spi.OpDependency;

public class OpDependencies {
    public static double size(double[] inArray) {
        return inArray.length;
    }

    public static double sum(double[] inArray) {
        return Arrays.stream(inArray).sum();
    }

    public static double mean(@OpDependency(name="stats.sum") Function<double[], Double> sumOp, @OpDependency(name="stats.size") Function<double[], Double> sizeOp, double[] inArray) {
        return sumOp.apply(inArray) / sizeOp.apply(inArray);
    }

    public static void main(String ... args) {
        OpEnvironment ops = OpEnvironment.build();
        double[] arr = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double mean = (Double)ops.op("stats.mean").input((Object)arr).outType(Double.class).apply();
        System.out.println("The mean of array " + Arrays.toString(arr) + " is " + mean);
    }
}

