/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;

public class BeanUtils {
    static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);

    public static <E> E getInstance(Class<E> clazz) {
        try {
            int isAstract = clazz.getModifiers() & 0x400;
            if (isAstract != 0) {
                logger.warn("getInstance: " + clazz + " is abstract");
                return null;
            }
            Object o = ConstructorUtils.invokeConstructor(clazz, (Object[])null);
            return (E)o;
        }
        catch (NoSuchMethodException e) {
            logger.error("getInstance", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error("getInstance", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error("getInstance", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            logger.error("getInstance", (Throwable)e);
            return null;
        }
    }

    public static Class<?> getFieldType(Class<?> clazz, String name) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(clazz);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                return descriptors[i].getPropertyType();
            }
        }
        return null;
    }

    public static Object getProperty(Object bean, String name) {
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)name);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SqlRuntimeException(e);
        }
    }

    public static Method getGetter(Class<?> clazz, String attributeName) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(clazz);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!attributeName.equals(descriptors[i].getName())) continue;
                return PropertyUtils.getReadMethod((PropertyDescriptor)descriptors[i]);
            }
        }
        return null;
    }

    public static Method getGetter(Object bean, String attributeName) {
        PropertyDescriptor descriptor;
        try {
            descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)attributeName);
        }
        catch (IllegalAccessException e) {
            logger.error("getProperty", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error("getProperty", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.error("getProperty", (Throwable)e);
            return null;
        }
        if (descriptor == null) {
            return null;
        }
        Method m = PropertyUtils.getReadMethod((PropertyDescriptor)descriptor);
        return m;
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)name, (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SqlRuntimeException(e);
        }
    }

    public static Method getSetter(Object bean, String attributeName, Class<?> ... classes) {
        PropertyDescriptor descriptor;
        try {
            descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)attributeName);
        }
        catch (IllegalAccessException e) {
            logger.error("getProperty", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.error("getProperty", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.error("getProperty", (Throwable)e);
            return null;
        }
        if (descriptor == null) {
            return null;
        }
        Method m = PropertyUtils.getWriteMethod((PropertyDescriptor)descriptor);
        if (m == null) {
            return null;
        }
        if (m.getParameterTypes() == null || m.getParameterTypes().length != 1) {
            return null;
        }
        Class<?> parameterClass = m.getParameterTypes()[0];
        if (classes == null) {
            return m;
        }
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(parameterClass)) continue;
            return m;
        }
        return null;
    }

    public static Object simpleInvokeMethod(Method m, Object obj, Object param) {
        Object result;
        if (m != null) {
            try {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                result = m.invoke(obj, param);
            }
            catch (IllegalAccessException e) {
                throw new SqlRuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder("Not compatible output value of type ").append(param != null ? param.getClass() : "null");
                sb.append(". The result class of type ").append(obj != null ? obj.getClass() : "null");
                sb.append(" for the method ").append(m.getName());
                sb.append(" is expecting the paramater(s) of type(s) ").append(m.getParameterTypes() != null ? Arrays.asList(m.getParameterTypes()) : "empty");
                sb.append(".");
                throw new SqlRuntimeException(sb.toString(), e);
            }
            catch (InvocationTargetException e) {
                throw new SqlRuntimeException(e);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static Object invokeMethod(Object obj, String methodName, Object[] args) {
        try {
            return MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])args);
        }
        catch (NoSuchMethodException e) {
            throw new SqlRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new SqlRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new SqlRuntimeException(e);
        }
    }
}

