/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.appium;

import jersey.repackaged.com.google.common.base.Optional;
import org.testobject.appium.ResultReporter;
import org.testobject.appium.TestObjectListenerProvider;
import org.testobject.rest.api.appium.common.data.SuiteReport;
import org.testobject.rest.api.appium.common.data.Test;
import org.testobject.rest.api.appium.common.data.TestReport;
import org.testobject.rest.api.appium.common.data.TestResult;
import org.testobject.rest.api.resource.AppiumSuiteReportResource;

public class SuiteReporter
extends ResultReporter {
    private SuiteReport suiteReport;
    private long suiteId;

    public void setSuiteReport(SuiteReport suiteReport) {
        this.suiteReport = suiteReport;
    }

    public void setSuiteId(long suiteId) {
        this.suiteId = suiteId;
    }

    public void processAndReportResult(boolean passed, Test test) {
        this.processResult(passed);
        this.reportResult(passed, test);
    }

    public void reportResult(boolean passed, Test test) {
        if (this.suiteReport == null) {
            this.createSuiteReportAndTestReport(passed);
        } else {
            this.updateSuiteReport(this.suiteReport, test, passed);
        }
    }

    private void updateSuiteReport(SuiteReport suiteReport, Test test, boolean passed) {
        Optional testReportId = suiteReport.getTestReportId(test);
        if (testReportId.orNull() == null) {
            throw new IllegalArgumentException("unknown test " + test);
        }
        new AppiumSuiteReportResource(this.client).finishTestReport(this.suiteId, suiteReport.getId(), (TestReport.Id)testReportId.orNull(), new TestResult(passed));
    }

    public SuiteReport suiteReport() {
        return this.suiteReport;
    }

    public void setProvider(TestObjectListenerProvider provider) {
        this.provider = provider;
        super.initClient();
    }
}

