/*
 * Decompiled with CFR 0.152.
 */
package org.testobject.api.v2;

import java.io.Closeable;
import java.io.File;
import java.util.concurrent.TimeoutException;
import org.testobject.api.v2.InvalidUserInputServerException;
import org.testobject.api.v2.TestObjectRemoteClientV2;
import org.testobject.rest.api.model.DynamicInstrumentationRequestData;
import org.testobject.rest.api.model.InstrumentationReport;
import org.testobject.rest.api.model.StartInstrumentationResponse;
import org.testobject.rest.api.model.StaticInstrumentationRequestData;
import org.testobject.rest.api.model.TestSuiteReport;
import org.testobject.rest.api.resource.v2.TestSuiteResourceV2;

public interface TestObjectClientV2
extends Closeable {
    public long uploadRunnerIpa(String var1, File var2) throws InvalidUserInputServerException;

    public long uploadAppIpa(String var1, File var2) throws InvalidUserInputServerException;

    public long uploadRunnerApk(String var1, File var2) throws InvalidUserInputServerException;

    public long uploadAppApk(String var1, File var2) throws InvalidUserInputServerException;

    public StartInstrumentationResponse startXcuiTestSuite(String var1, StaticInstrumentationRequestData var2);

    public StartInstrumentationResponse startXcuiTestSuite(String var1, DynamicInstrumentationRequestData var2);

    public StartInstrumentationResponse startAndroidSuite(String var1, StaticInstrumentationRequestData var2);

    public String readJunitReport(String var1, long var2);

    public InstrumentationReport waitForInstrumentationReport(String var1, long var2, long var4, long var6) throws TimeoutException;

    public void updateInstrumentationTestSuite(long var1, File var3, File var4, TestSuiteResourceV2.InstrumentationTestSuiteRequest var5, String var6);

    public long startInstrumentationTestSuite(long var1, String var3);

    public TestSuiteReport waitForSuiteReport(long var1, long var3, long var5, String var7);

    public String readTestSuiteXMLReport(long var1, String var3);

    @Override
    public void close();

    public static final class Factory {
        private static final String BASE_URL = "https://appium.testobject.com/api/rest";

        public static TestObjectClientV2 create() {
            return Factory.create(BASE_URL, null);
        }

        public static TestObjectClientV2 create(String baseUrl) {
            return Factory.create(baseUrl, null);
        }

        public static TestObjectClientV2 create(String baseUrl, ProxySettings proxySettings) {
            return new TestObjectRemoteClientV2(baseUrl, proxySettings);
        }
    }

    public static final class ProxySettings {
        private final String host;
        private final int port;
        private final String username;
        private final String password;

        public ProxySettings(String host, int port, String username, String password) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

