/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.configuration;

import org.osiam.security.authorization.OsiamMethodSecurityExpressionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;

@Configuration
@EnableResourceServer
public class OAuth2ResourceServerConfig
extends ResourceServerConfigurerAdapter {
    @Autowired
    private DefaultTokenServices tokenService;

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.resourceId("oauth2res").tokenServices((ResourceServerTokenServices)this.tokenService).expressionHandler((SecurityExpressionHandler)new OsiamMethodSecurityExpressionHandler());
    }

    public void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/ServiceProviderConfig"})).permitAll().antMatchers(new String[]{"/Me/**"})).access("#oauth2.hasScope('ADMIN') or #oauth2.hasScope('ME')").antMatchers(HttpMethod.POST, new String[]{"/Users/**"})).access("#oauth2.hasScope('ADMIN')").regexMatchers(HttpMethod.GET, new String[]{"/Users/?"})).access("#oauth2.hasScope('ADMIN')").antMatchers(new String[]{"/Users/**"})).access("#oauth2.hasScope('ADMIN') or #oauth2.hasScope('ME') and #osiam.isOwnerOfResource()").antMatchers(new String[]{"/token/validation"})).authenticated().antMatchers(new String[]{"/token/revocation", "/token/revocation/"})).access("#oauth2.hasScope('ADMIN') or #oauth2.hasScope('ME')").antMatchers(new String[]{"/token/revocation/**"})).access("#oauth2.hasScope('ADMIN') or #oauth2.hasScope('ME') and #osiam.isOwnerOfResource()").anyRequest()).access("#oauth2.hasScope('ADMIN')");
    }
}

