/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.controller;

import com.google.common.base.Strings;
import javax.servlet.http.HttpServletResponse;
import org.osiam.resources.controller.ResourceController;
import org.osiam.resources.exception.InvalidTokenException;
import org.osiam.resources.provisioning.SCIMUserProvisioning;
import org.osiam.resources.scim.Resource;
import org.osiam.resources.scim.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/Me"})
@Transactional
public class MeController
extends ResourceController<User> {
    private final ResourceServerTokenServices resourceServerTokenServices;
    private final SCIMUserProvisioning userProvisioning;

    @Autowired
    public MeController(ResourceServerTokenServices resourceServerTokenServices, SCIMUserProvisioning userProvisioning) {
        this.resourceServerTokenServices = resourceServerTokenServices;
        this.userProvisioning = userProvisioning;
    }

    @RequestMapping(method={RequestMethod.GET})
    public MappingJacksonValue getCurrentUser(@RequestHeader(value="Authorization") String tokenHeader, @RequestParam(required=false) String attributes, HttpServletResponse response, UriComponentsBuilder builder) {
        if (Strings.isNullOrEmpty((String)tokenHeader)) {
            throw new IllegalArgumentException("No access token provided!");
        }
        String accessToken = tokenHeader.substring("Bearer ".length());
        OAuth2Authentication oAuth = this.resourceServerTokenServices.loadAuthentication(accessToken);
        if (oAuth.isClientOnly()) {
            throw new InvalidTokenException("Can't return an user. This access token belongs to a client.");
        }
        Authentication userAuthentication = oAuth.getUserAuthentication();
        Object principal = userAuthentication.getPrincipal();
        if (!(principal instanceof User)) {
            throw new IllegalArgumentException("User not authenticated.");
        }
        User user = this.userProvisioning.getById(((User)principal).getId());
        response.setHeader("Location", this.buildLocation((Resource)user, builder).toString());
        return this.buildResponse((Object)user, attributes);
    }
}

