/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.converter;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.osiam.resources.converter.Converter;
import org.osiam.resources.scim.Extension;
import org.osiam.resources.scim.ExtensionFieldType;
import org.osiam.storage.ExtensionRepository;
import org.osiam.storage.entities.ExtensionEntity;
import org.osiam.storage.entities.ExtensionFieldEntity;
import org.osiam.storage.entities.ExtensionFieldValueEntity;
import org.osiam.storage.helper.NumberPadder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtensionConverter
implements Converter<Set<Extension>, Set<ExtensionFieldValueEntity>> {
    private final ExtensionRepository extensionRepository;
    private final NumberPadder numberPadder;

    @Autowired
    public ExtensionConverter(ExtensionRepository extensionRepository) {
        this.extensionRepository = extensionRepository;
        this.numberPadder = new NumberPadder();
    }

    public Set<ExtensionFieldValueEntity> fromScim(Set<Extension> extensions) {
        HashSet<ExtensionFieldValueEntity> result = new HashSet<ExtensionFieldValueEntity>();
        for (Extension extension : (Set)Preconditions.checkNotNull(extensions)) {
            String urn = extension.getUrn();
            ExtensionEntity extensionEntity = this.extensionRepository.findByUrn(urn);
            for (ExtensionFieldEntity field : extensionEntity.getFields()) {
                if (!extension.isFieldPresent(field.getName()) || Strings.isNullOrEmpty((String)((String)extension.getField(field.getName(), ExtensionFieldType.STRING)))) continue;
                ExtensionFieldValueEntity value = new ExtensionFieldValueEntity();
                String typeCheckedStringValue = this.getTypeCheckedStringValue(field.getType(), field.getName(), extension);
                if (field.getType() == ExtensionFieldType.INTEGER || field.getType() == ExtensionFieldType.DECIMAL) {
                    typeCheckedStringValue = this.numberPadder.pad(typeCheckedStringValue);
                }
                value.setValue(typeCheckedStringValue);
                value.setExtensionField(field);
                result.add(value);
            }
        }
        return result;
    }

    private <T> String getTypeCheckedStringValue(ExtensionFieldType<T> type, String fieldName, Extension extension) {
        Object value = extension.getField(fieldName, type);
        return type.toString(value);
    }

    public Set<Extension> toScim(Set<ExtensionFieldValueEntity> entity) {
        HashMap<String, Extension.Builder> extensionMap = new HashMap<String, Extension.Builder>();
        for (ExtensionFieldValueEntity fieldValueEntity : (Set)Preconditions.checkNotNull(entity)) {
            Extension.Builder extensionBuilder;
            String urn = fieldValueEntity.getExtensionField().getExtension().getUrn();
            if (extensionMap.containsKey(urn)) {
                extensionBuilder = (Extension.Builder)extensionMap.get(urn);
            } else {
                extensionBuilder = new Extension.Builder(urn);
                extensionMap.put(urn, extensionBuilder);
            }
            ExtensionFieldType type = fieldValueEntity.getExtensionField().getType();
            if (type == null) {
                throw new IllegalArgumentException("The ExtensionField type can't be null");
            }
            String value = fieldValueEntity.getValue();
            if (type == ExtensionFieldType.INTEGER || type == ExtensionFieldType.DECIMAL) {
                value = this.numberPadder.unpad(value);
            }
            String name = fieldValueEntity.getExtensionField().getName();
            this.addField(extensionBuilder, type, name, value);
        }
        HashSet<Extension> extensions = new HashSet<Extension>();
        for (Extension.Builder builder : extensionMap.values()) {
            extensions.add(builder.build());
        }
        return extensions;
    }

    private <T> void addField(Extension.Builder extensionBuilder, ExtensionFieldType<T> type, String fieldName, String stringValue) {
        extensionBuilder.setField(fieldName, type.fromString(stringValue), type);
    }
}

