/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.resources.provisioning.update;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.osiam.resources.converter.X509CertificateConverter;
import org.osiam.resources.scim.X509Certificate;
import org.osiam.storage.entities.UserEntity;
import org.osiam.storage.entities.X509CertificateEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class X509CertificateUpdater {
    private final X509CertificateConverter x509CertificateConverter;

    @Autowired
    public X509CertificateUpdater(X509CertificateConverter x509CertificateConverter) {
        this.x509CertificateConverter = x509CertificateConverter;
    }

    void update(List<X509Certificate> x509Certificates, UserEntity userEntity, Set<String> attributes) {
        if (attributes.contains("x509Certificates")) {
            userEntity.removeAllX509Certificates();
        }
        if (x509Certificates != null) {
            for (X509Certificate scimX509Certificate : x509Certificates) {
                X509CertificateEntity x509CertificateEntity = this.x509CertificateConverter.fromScim(scimX509Certificate);
                userEntity.removeX509Certificate(x509CertificateEntity);
                if (!Strings.isNullOrEmpty((String)scimX509Certificate.getOperation()) && scimX509Certificate.getOperation().equalsIgnoreCase("delete")) continue;
                this.ensureOnlyOnePrimaryX509CertificateExists(x509CertificateEntity, userEntity.getX509Certificates());
                userEntity.addX509Certificate(x509CertificateEntity);
            }
        }
    }

    private void ensureOnlyOnePrimaryX509CertificateExists(X509CertificateEntity newX509Certificate, Set<X509CertificateEntity> x509Certificates) {
        if (newX509Certificate.isPrimary()) {
            for (X509CertificateEntity existingX509CertificateEntity : x509Certificates) {
                if (!existingX509CertificateEntity.isPrimary()) continue;
                existingX509CertificateEntity.setPrimary(false);
            }
        }
    }
}

