/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.scim.extension;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.osiam.resources.scim.ExtensionFieldType;
import org.osiam.storage.ExtensionRepository;
import org.osiam.storage.entities.ExtensionEntity;
import org.osiam.storage.entities.ExtensionFieldEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsiamExtension {
    public static final String URN = "urn:org.osiam:scim:extensions:auth-server";
    private final ExtensionRepository extensionRepository;

    @Autowired
    public OsiamExtension(ExtensionRepository extensionRepository) {
        this.extensionRepository = extensionRepository;
    }

    @PostConstruct
    public void create() throws Exception {
        if (!this.extensionRepository.existsByUrnIgnoreCase(URN)) {
            ExtensionFieldEntity field = new ExtensionFieldEntity();
            field.setName("origin");
            field.setType(ExtensionFieldType.STRING);
            field.setRequired(false);
            ExtensionEntity extension = new ExtensionEntity();
            extension.setUrn(URN);
            extension.setFields((Set)Sets.newHashSet((Object[])new ExtensionFieldEntity[]{field}));
            field.setExtension(extension);
            this.extensionRepository.saveAndFlush((Object)extension);
        }
    }
}

