/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.security.controller;

import javax.servlet.http.HttpServletRequest;
import org.osiam.auth.token.TokenService;
import org.osiam.client.oauth.AccessToken;
import org.osiam.security.authentication.AuthenticationError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/token"})
public class TokenController {
    private final TokenService tokenService;

    @Autowired
    public TokenController(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    @RequestMapping(value={"/validation"}, method={RequestMethod.POST})
    @ResponseBody
    public AccessToken validateToken(@RequestHeader(value="Authorization") String authorization) {
        return this.tokenService.validateToken(this.getToken(authorization));
    }

    @RequestMapping(value={"/revocation"}, method={RequestMethod.POST})
    @ResponseBody
    public void revokeToken(@RequestHeader(value="Authorization") String authorization) {
        this.tokenService.revokeToken(this.getToken(authorization));
    }

    @RequestMapping(value={"/revocation/{userId}"}, method={RequestMethod.POST})
    @ResponseBody
    public void revokeAllTokensOfUser(@PathVariable(value="userId") String userId) {
        this.tokenService.revokeAllTokensOfUser(userId);
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public AuthenticationError handleException(InvalidTokenException ex, HttpServletRequest request) {
        return new AuthenticationError("invalid_token", ex.getMessage());
    }

    private String getToken(String authorization) {
        int lastIndexOf = authorization.lastIndexOf(32);
        return authorization.substring(lastIndexOf + 1);
    }
}

