/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.dao;

import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.SingularAttribute;
import org.antlr.v4.runtime.tree.ParseTree;
import org.osiam.resources.exception.OsiamException;
import org.osiam.resources.exception.ResourceNotFoundException;
import org.osiam.storage.dao.SearchResult;
import org.osiam.storage.entities.GroupEntity;
import org.osiam.storage.entities.ResourceEntity;
import org.osiam.storage.entities.ResourceEntity_;
import org.osiam.storage.query.FilterParser;
import org.springframework.stereotype.Repository;

@Repository
public class ResourceDao {
    @PersistenceContext
    private EntityManager em;

    public <T extends ResourceEntity> SearchResult<T> search(Class<T> clazz, ParseTree filterTree, int count, int startIndex, String sortBy, String sortOrder, FilterParser<T> filterParser) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery resourceQuery = cb.createQuery(clazz);
        Root resourceRoot = resourceQuery.from(clazz);
        Subquery internalIdQuery = resourceQuery.subquery(Long.class);
        Root internalIdRoot = internalIdQuery.from(clazz);
        internalIdQuery.select((Expression)internalIdRoot.get(ResourceEntity_.internalId));
        if (filterTree != null && filterTree.getChildCount() > 0) {
            Predicate predicate = filterParser.createPredicateAndJoin(filterTree, internalIdRoot);
            internalIdQuery.where((Expression)predicate);
        }
        resourceQuery.select((Selection)resourceRoot).where((Expression)cb.in((Expression)resourceRoot.get(ResourceEntity_.internalId)).value((Expression)internalIdQuery));
        Path sortByField = resourceRoot.get(ResourceEntity_.id);
        if (sortBy != null && !sortBy.isEmpty()) {
            sortByField = filterParser.createSortByField(sortBy, resourceRoot);
        }
        Order order = cb.asc((Expression)sortByField);
        if (sortOrder.equalsIgnoreCase("descending")) {
            order = cb.desc((Expression)sortByField);
        }
        resourceQuery.orderBy(new Order[]{order});
        TypedQuery query = this.em.createQuery(resourceQuery);
        query.setFirstResult(startIndex);
        query.setMaxResults(count);
        List results = query.getResultList();
        long totalResult = this.getTotalResults(clazz, internalIdQuery);
        return new SearchResult(results, totalResult);
    }

    private <T extends ResourceEntity> long getTotalResults(Class<T> clazz, Subquery<Long> internalIdQuery) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery resourceQuery = cb.createQuery(Long.class);
        Root resourceRoot = resourceQuery.from(clazz);
        resourceQuery.select((Selection)cb.count((Expression)resourceRoot)).where((Expression)cb.in((Expression)resourceRoot.get(ResourceEntity_.internalId)).value(internalIdQuery));
        return (Long)this.em.createQuery(resourceQuery).getSingleResult();
    }

    public <T extends ResourceEntity> T getById(String id, Class<T> clazz) {
        return (T)this.getByAttribute(ResourceEntity_.id, (Object)id, clazz);
    }

    public <T extends ResourceEntity, V> T getByAttribute(SingularAttribute<? super T, V> attribute, V value, Class<T> clazz) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(clazz);
        Root resource = cq.from(clazz);
        cq.select((Selection)resource).where((Expression)cb.equal((Expression)resource.get(attribute), value));
        TypedQuery q = this.em.createQuery(cq);
        try {
            return (T)((ResourceEntity)q.getSingleResult());
        }
        catch (NoResultException nre) {
            throw new ResourceNotFoundException(String.format("Resource with attribute '%s' set to '%s' not found", attribute.getName(), value), (Throwable)nre);
        }
        catch (NonUniqueResultException nure) {
            throw new OsiamException(String.format("Muliple resources with attribute '%s' set to '%s' found", attribute.getName(), value), (Throwable)nure);
        }
    }

    public <T extends ResourceEntity, V> boolean isUniqueAttributeAlreadyTaken(String attributeValue, String id, SingularAttribute<? super T, V> attribute, Class<T> clazz) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root resource = cq.from(clazz);
        cq.select((Selection)cb.countDistinct((Expression)resource));
        Predicate predicate = cb.equal((Expression)resource.get(attribute), (Object)attributeValue);
        if (id != null) {
            Predicate ignoreId = cb.notEqual((Expression)resource.get(ResourceEntity_.id), (Object)id);
            predicate = cb.and((Expression)predicate, (Expression)ignoreId);
        }
        cq.where((Expression)predicate);
        TypedQuery countQuery = this.em.createQuery(cq);
        return (Long)countQuery.getSingleResult() > 0L;
    }

    public boolean isExternalIdAlreadyTaken(String externalId, String id) {
        return this.isUniqueAttributeAlreadyTaken(externalId, id, ResourceEntity_.externalId, ResourceEntity.class);
    }

    public boolean isExternalIdAlreadyTaken(String externalId) {
        return this.isExternalIdAlreadyTaken(externalId, null);
    }

    public <T extends ResourceEntity> long count(Class<T> clazz) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        query.select((Selection)cb.count((Expression)query.from(clazz)));
        return (Long)this.em.createQuery(query).getSingleResult();
    }

    public void delete(String id) {
        ResourceEntity resourceEntity = this.getById(id, ResourceEntity.class);
        Set groups = resourceEntity.getGroups();
        for (GroupEntity group : groups) {
            group.removeMember(resourceEntity);
        }
        this.em.remove((Object)resourceEntity);
    }

    public <T extends ResourceEntity> T update(T resourceEntity) {
        return (T)((ResourceEntity)this.em.merge(resourceEntity));
    }

    public <T extends ResourceEntity> void create(T resourceEntity) {
        this.em.persist(resourceEntity);
    }
}

