/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.entities;

import java.util.Calendar;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="scim_meta", indexes={@Index(columnList="created"), @Index(columnList="lastModified")})
public class MetaEntity {
    private static final int SEQUENCE_ALLOCATION_SIZE = 1;
    private static final int SEQUENCE_INITIAL_VALUE = 100;
    @Id
    @SequenceGenerator(name="sequence_scim_meta", sequenceName="resource_server_sequence_scim_meta", allocationSize=1, initialValue=100)
    @GeneratedValue(generator="sequence_scim_meta")
    private long id;
    private Date created;
    private Date lastModified;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String location;
    private String version;
    private String resourceType;

    public MetaEntity(Calendar instance) {
        this.created = instance.getTime();
        this.lastModified = instance.getTime();
    }

    public MetaEntity() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created != null ? (Date)this.created.clone() : null;
    }

    public void setCreated(Date created) {
        this.created = created != null ? new Date(created.getTime()) : null;
    }

    public Date getLastModified() {
        return this.lastModified != null ? (Date)this.lastModified.clone() : null;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified != null ? new Date(lastModified.getTime()) : null;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaEntity other = (MetaEntity)obj;
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.resourceType == null ? other.resourceType != null : !this.resourceType.equals(other.resourceType)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "MetaEntity [created=" + this.created + ", lastModified=" + this.lastModified + ", location=" + this.location + ", version=" + this.version + ", resourceType=" + this.resourceType + "]";
    }
}

