/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.entities;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Type;
import org.osiam.resources.scim.MemberRef;
import org.osiam.storage.entities.AddressEntity;
import org.osiam.storage.entities.EmailEntity;
import org.osiam.storage.entities.EntitlementEntity;
import org.osiam.storage.entities.ExtensionFieldValueEntity;
import org.osiam.storage.entities.ImEntity;
import org.osiam.storage.entities.NameEntity;
import org.osiam.storage.entities.PhoneNumberEntity;
import org.osiam.storage.entities.PhotoEntity;
import org.osiam.storage.entities.ResourceEntity;
import org.osiam.storage.entities.RoleEntity;
import org.osiam.storage.entities.X509CertificateEntity;

@Entity
@Table(name="scim_user")
public class UserEntity
extends ResourceEntity {
    public static final String JOIN_COLUMN_NAME = "user_internal_id";
    private static final int BATCH_SIZE = 100;
    @Column(nullable=false, unique=true)
    private String userName;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    private NameEntity name;
    private String nickName;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String profileUrl;
    private String title;
    private String userType;
    private String preferredLanguage;
    private String locale;
    private String timezone;
    private Boolean active = Boolean.FALSE;
    @Column(nullable=false)
    private String password;
    private String displayName;
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<EmailEntity> emails = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<PhoneNumberEntity> phoneNumbers = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<ImEntity> ims = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<PhotoEntity> photos = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<AddressEntity> addresses = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<EntitlementEntity> entitlements = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<RoleEntity> roles = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<X509CertificateEntity> x509Certificates = new HashSet();
    @BatchSize(size=100)
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_internal_id", nullable=false)
    private Set<ExtensionFieldValueEntity> extensionFieldValues = new HashSet();

    public UserEntity() {
        this.getMeta().setResourceType("User");
    }

    public NameEntity getName() {
        return this.name;
    }

    public void setName(NameEntity name) {
        this.name = name;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Set<EmailEntity> getEmails() {
        return ImmutableSet.copyOf((Collection)this.emails);
    }

    public void addEmail(EmailEntity email) {
        this.emails.add(email);
    }

    public void removeEmail(EmailEntity email) {
        this.emails.remove(email);
    }

    public void removeAllEmails() {
        this.emails.clear();
    }

    public Set<ExtensionFieldValueEntity> getExtensionFieldValues() {
        return this.extensionFieldValues;
    }

    public void addExtensionFieldValue(ExtensionFieldValueEntity extensionFieldValue) {
        this.extensionFieldValues.add(extensionFieldValue);
    }

    public void removeExtensionFieldValue(ExtensionFieldValueEntity extensionFieldValue) {
        this.extensionFieldValues.remove(extensionFieldValue);
    }

    public void removeAllExtensionFieldValues(String urn) {
        ImmutableSet fields = ImmutableSet.copyOf((Collection)this.extensionFieldValues);
        for (ExtensionFieldValueEntity extensionFieldValue : fields) {
            if (!extensionFieldValue.getExtensionField().getExtension().getUrn().equals(urn)) continue;
            this.extensionFieldValues.remove(extensionFieldValue);
        }
    }

    public void addOrUpdateExtensionValue(ExtensionFieldValueEntity extensionValue) {
        if (extensionValue == null) {
            throw new IllegalArgumentException("extensionValue must not be null");
        }
        if (this.extensionFieldValues.contains(extensionValue)) {
            this.extensionFieldValues.remove(extensionValue);
        }
        this.extensionFieldValues.add(extensionValue);
    }

    public Set<PhoneNumberEntity> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void addPhoneNumber(PhoneNumberEntity phoneNumber) {
        this.phoneNumbers.add(phoneNumber);
    }

    public void removePhoneNumber(PhoneNumberEntity phoneNumber) {
        this.phoneNumbers.remove(phoneNumber);
    }

    public void removeAllPhoneNumbers() {
        this.phoneNumbers.clear();
    }

    public Set<ImEntity> getIms() {
        return this.ims;
    }

    public void addIm(ImEntity im) {
        this.ims.add(im);
    }

    public void removeIm(ImEntity im) {
        this.ims.remove(im);
    }

    public void removeAllIms() {
        this.ims.clear();
    }

    public Set<PhotoEntity> getPhotos() {
        return this.photos;
    }

    public void addPhoto(PhotoEntity photo) {
        this.photos.add(photo);
    }

    public void removePhoto(PhotoEntity photo) {
        this.photos.remove(photo);
    }

    public void removeAllPhotos() {
        this.photos.clear();
    }

    public Set<AddressEntity> getAddresses() {
        return this.addresses;
    }

    public void addAddress(AddressEntity address) {
        this.addresses.add(address);
    }

    public void removeAddress(AddressEntity address) {
        this.addresses.remove(address);
    }

    public void removeAllAddresses() {
        this.addresses.clear();
    }

    public Set<EntitlementEntity> getEntitlements() {
        return this.entitlements;
    }

    public void addEntitlement(EntitlementEntity entitlement) {
        this.entitlements.add(entitlement);
    }

    public void removeEntitlement(EntitlementEntity entitlement) {
        this.entitlements.remove(entitlement);
    }

    public void removeAllEntitlements() {
        this.entitlements.clear();
    }

    public Set<RoleEntity> getRoles() {
        return this.roles;
    }

    public void addRole(RoleEntity role) {
        this.roles.add(role);
    }

    public void removeRole(RoleEntity role) {
        this.roles.remove(role);
    }

    public void removeAllRoles() {
        this.roles.clear();
    }

    public Set<X509CertificateEntity> getX509Certificates() {
        return this.x509Certificates;
    }

    public void addX509Certificate(X509CertificateEntity x509Certificate) {
        this.x509Certificates.add(x509Certificate);
    }

    public void removeX509Certificate(X509CertificateEntity x509Certificate) {
        this.x509Certificates.remove(x509Certificate);
    }

    public void removeAllX509Certificates() {
        this.x509Certificates.clear();
    }

    public String toString() {
        return "UserEntity [userName=" + this.userName + ", getId()=" + this.getId() + "]";
    }

    public MemberRef.Type getType() {
        return MemberRef.Type.USER;
    }
}

