/*
 * Decompiled with CFR 0.152.
 */
package org.osiam.storage.query;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.SetAttribute;
import org.osiam.resources.exception.InvalidFilterException;
import org.osiam.resources.scim.ExtensionFieldType;
import org.osiam.storage.entities.ExtensionFieldEntity;
import org.osiam.storage.entities.ExtensionFieldEntity_;
import org.osiam.storage.entities.ExtensionFieldValueEntity;
import org.osiam.storage.entities.ExtensionFieldValueEntity_;
import org.osiam.storage.entities.UserEntity;
import org.osiam.storage.entities.UserEntity_;
import org.osiam.storage.helper.NumberPadder;
import org.osiam.storage.query.FilterConstraint;

public class ExtensionQueryField {
    private final String urn;
    private final ExtensionFieldEntity field;
    private final NumberPadder numberPadder;

    public ExtensionQueryField(String urn, ExtensionFieldEntity field) {
        this.urn = urn;
        this.field = field;
        this.numberPadder = new NumberPadder();
    }

    public Predicate addFilter(Root<UserEntity> root, FilterConstraint constraint, String value, CriteriaBuilder cb) {
        if (constraint != FilterConstraint.PRESENT && (this.field.getType() == ExtensionFieldType.INTEGER || this.field.getType() == ExtensionFieldType.DECIMAL)) {
            try {
                value = this.numberPadder.pad(value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidFilterException(ex.getMessage());
            }
        }
        SetJoin join = this.createOrGetJoin(this.generateAlias(String.valueOf(this.urn) + "." + this.field.getName()), root, UserEntity_.extensionFieldValues);
        Predicate filterPredicate = constraint.createPredicateForExtensionField(join.get(ExtensionFieldValueEntity_.value), value, this.field, cb);
        Predicate valueBelongsToField = cb.equal((Expression)join.get(ExtensionFieldValueEntity_.extensionField).get(ExtensionFieldEntity_.internalId), (Object)this.field.getInternalId());
        join.on((Expression)valueBelongsToField);
        return filterPredicate;
    }

    private String generateAlias(String value) {
        int hashCode = value.hashCode();
        if (hashCode < 0) {
            hashCode *= -1;
        }
        return "extensionFieldAlias" + hashCode;
    }

    protected SetJoin<UserEntity, ExtensionFieldValueEntity> createOrGetJoin(String alias, Root<UserEntity> root, SetAttribute<UserEntity, ExtensionFieldValueEntity> attribute) {
        for (Join currentJoin : root.getJoins()) {
            if (currentJoin.getAlias() == null || !currentJoin.getAlias().equals(alias)) continue;
            return (SetJoin)currentJoin;
        }
        SetJoin join = root.join(attribute, JoinType.LEFT);
        join.alias(alias);
        return join;
    }
}

