/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.selenium.containers.browser;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.timeouts.Timeouts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.utility.DockerImageName;
import software.xdev.testcontainers.selenium.containers.recorder.RecordingContainer;
import software.xdev.testcontainers.selenium.containers.recorder.SeleniumRecordingContainer;

public class BrowserWebDriverContainer<SELF extends BrowserWebDriverContainer<SELF>>
extends GenericContainer<SELF>
implements TestLifecycleAware {
    protected static final Logger LOG = LoggerFactory.getLogger(BrowserWebDriverContainer.class);
    protected static final DockerImageName CHROME_IMAGE = DockerImageName.parse((String)"selenium/standalone-chrome");
    protected static final DockerImageName FIREFOX_IMAGE = DockerImageName.parse((String)"selenium/standalone-firefox");
    protected static final DockerImageName EDGE_IMAGE = DockerImageName.parse((String)"selenium/standalone-edge");
    protected static final Map<DockerImageName, String> WORKING_BROWSER_IMAGES_TRANSLATION = Collections.synchronizedMap(new HashMap());
    public static final int SELENIUM_PORT = 4444;
    public static final int VNC_PORT = 5900;
    public static final int NO_VNC_PORT = 7900;
    public static final String DEFAULT_VNC_PASSWORD = "secret";
    protected static final String TC_TEMP_DIR_PREFIX = "tc";
    protected boolean mapTimezoneIntoContainer = true;
    protected boolean validateImageEnabled = true;
    protected Duration validateImageGetTimeout = Duration.ofMinutes(5L);
    protected boolean disableVNC = true;
    protected boolean exposeVNCPort;
    protected boolean enableNoVNC;
    protected Function<SELF, RecordingContainer<?>> recordingContainerSupplier = SeleniumRecordingContainer::new;
    protected RecordingContainer<?> recordingContainer;
    protected boolean startRecordingContainerManually;
    protected RecordingMode recordingMode = RecordingMode.SKIP;
    protected Path recordingDirectory;
    protected TestRecordingFileNameFactory testRecordingFileNameFactory = new DefaultTestRecordingFileNameFactory();
    protected Duration recordingSaveTimeout = Duration.ofMinutes(3L);

    public BrowserWebDriverContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public BrowserWebDriverContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.waitStrategy = this.getDefaultWaitStrategy();
    }

    protected WaitStrategy getDefaultWaitStrategy() {
        return new WaitAllStrategy().withStrategy(new LogMessageWaitStrategy().withRegEx(".*(Started Selenium Standalone).*\n").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS))).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
    }

    public SELF withMapTimezoneIntoContainer(boolean mapTimezoneIntoContainer) {
        this.mapTimezoneIntoContainer = mapTimezoneIntoContainer;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withValidateImage(boolean validateImage) {
        this.validateImageEnabled = validateImage;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withValidateImageGetTimeout(Duration validateImageGetTimeout) {
        this.validateImageGetTimeout = validateImageGetTimeout;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withDisableVNC(boolean disableVNC) {
        this.disableVNC = disableVNC;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withExposeVNCPort(boolean exposeVNCPort) {
        this.exposeVNCPort = exposeVNCPort;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withEnableNoVNC(boolean enableNoVNC) {
        this.enableNoVNC = enableNoVNC;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingContainerSupplier(Function<SELF, RecordingContainer<?>> recordingContainerSupplier) {
        this.recordingContainerSupplier = recordingContainerSupplier;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withStartRecordingContainerManually(boolean startRecordingContainerManually) {
        this.startRecordingContainerManually = startRecordingContainerManually;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingMode(RecordingMode recordingMode) {
        this.recordingMode = recordingMode;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingDirectory(Path recordingDirectory) {
        this.recordingDirectory = recordingDirectory;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withTestRecordingFileNameFactory(TestRecordingFileNameFactory testRecordingFileNameFactory) {
        this.testRecordingFileNameFactory = testRecordingFileNameFactory;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    public SELF withRecordingSaveTimeout(Duration recordingSaveTimeout) {
        this.recordingSaveTimeout = recordingSaveTimeout;
        return (SELF)((Object)((BrowserWebDriverContainer)this.self()));
    }

    protected void configure() {
        this.configureRecording();
        this.configureTimezone();
        this.setCommand("/opt/bin/entry_point.sh");
        this.configureShm();
        this.setStartupAttempts(3);
        this.addExposedPorts(new int[]{4444});
        this.configureVNC();
        this.validateImage();
    }

    protected void configureRecording() {
        if (this.recordingMode == RecordingMode.SKIP) {
            return;
        }
        if (this.recordingDirectory == null) {
            try {
                this.recordingDirectory = Files.createTempDirectory(TC_TEMP_DIR_PREFIX, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ContainerLaunchException("Exception while trying to create temp directory", (Throwable)e);
            }
        }
        if (this.getNetwork() == null) {
            this.withNetwork(Network.SHARED);
        }
        this.recordingContainer = this.recordingContainerSupplier.apply((SELF)((Object)((BrowserWebDriverContainer)this.self())));
    }

    protected void configureTimezone() {
        if (this.mapTimezoneIntoContainer) {
            String timeZone = System.getProperty("user.timezone");
            if (timeZone == null || timeZone.isEmpty()) {
                timeZone = "Etc/UTC";
            }
            this.addEnv("TZ", timeZone);
        }
    }

    protected void configureShm() {
        if (this.getShmSize() == null) {
            if (Optional.ofNullable(System.getProperty("os.name")).map(osName -> osName.startsWith("Windows")).orElse(false).booleanValue()) {
                this.withSharedMemorySize(0x20000000L);
            } else {
                this.getBinds().add(new Bind("/dev/shm", new Volume("/dev/shm"), AccessMode.rw));
            }
        }
    }

    protected void configureVNC() {
        if (this.disableVNC) {
            this.addEnv("SE_START_VNC", "false");
            return;
        }
        if (this.exposeVNCPort) {
            this.addExposedPort(5900);
        }
        if (this.enableNoVNC) {
            this.addExposedPort(7900);
        }
    }

    protected void validateImage() {
        if (!this.validateImageEnabled) {
            return;
        }
        try {
            Field fImage = GenericContainer.class.getDeclaredField("image");
            fImage.setAccessible(true);
            RemoteDockerImage remoteDockerImage = (RemoteDockerImage)fImage.get((Object)this);
            Method mGetImageName = RemoteDockerImage.class.getDeclaredMethod("getImageName", new Class[0]);
            mGetImageName.setAccessible(true);
            DockerImageName currentImage = (DockerImageName)mGetImageName.invoke((Object)remoteDockerImage, new Object[0]);
            this.setDockerImageName(WORKING_BROWSER_IMAGES_TRANSLATION.computeIfAbsent(currentImage, this::validateImageOrPickAlternative));
        }
        catch (Exception ex) {
            LOG.warn("Failed to validate image or pick alternative; Using default", (Throwable)ex);
        }
    }

    protected String validateImageOrPickAlternative(DockerImageName initial) {
        RuntimeException prevEx = null;
        List<String> versionParts = List.of(initial.getVersionPart().split("\\."));
        ArrayList<String> tags = new ArrayList<String>(List.of(initial.getVersionPart()));
        IntStream.range(0, versionParts.size() - 1).map(i -> versionParts.size() - 1 - i).mapToObj(i -> versionParts.stream().limit(i).collect(Collectors.joining("."))).forEach(tags::add);
        for (String currentTag : tags) {
            try {
                DockerImageName current = initial.withTag(currentTag);
                Timeouts.getWithTimeout((int)((int)this.validateImageGetTimeout.toMillis()), (TimeUnit)TimeUnit.MILLISECONDS, () -> ((RemoteDockerImage)new RemoteDockerImage(current)).get());
                if (!Objects.equals(currentTag, initial.getVersionPart())) {
                    LOG.warn("Unable to use {}; Selecting alternative {} due to", new Object[]{initial, current, prevEx});
                }
                return current.asCanonicalNameString();
            }
            catch (RuntimeException rex) {
                if (prevEx != null) {
                    rex.addSuppressed(prevEx);
                }
                prevEx = rex;
            }
        }
        assert (prevEx != null);
        throw prevEx;
    }

    public String getVncAddress() {
        return !this.disableVNC && this.exposeVNCPort ? "vnc://vnc:secret@" + this.getHost() + ":" + this.getMappedPort(5900) : null;
    }

    public String getNoVncAddress() {
        return !this.disableVNC && this.enableNoVNC ? "http://" + this.getHost() + ":" + this.getMappedPort(7900) : null;
    }

    public URI getSeleniumAddressURI() {
        return URI.create("http://" + this.getHost() + ":" + this.getMappedPort(4444) + "/wd/hub");
    }

    public void stop() {
        this.stopRecordingContainer();
        super.stop();
    }

    public void afterTest(TestDescription description, Optional<Throwable> throwable) {
        this.retainRecordingIfNeeded(description.getFilesystemFriendlyName(), throwable.isEmpty());
    }

    protected void retainRecordingIfNeeded(String testName, boolean succeeded) {
        block8: {
            switch (this.recordingMode) {
                case RECORD_ALL: {
                    break;
                }
                case RECORD_FAILING: {
                    if (!succeeded) {
                        break;
                    }
                    break block8;
                }
                default: {
                    break block8;
                }
            }
            try {
                Path recording = (Path)Timeouts.getWithTimeout((int)((int)this.recordingSaveTimeout.toSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> this.recordingContainer.saveRecordingToFile(this.recordingDirectory, this.testRecordingFileNameFactory.buildNameWithoutExtension(testName, succeeded)));
                LOG.info("Screen recordings for test {} will be stored at: {}", (Object)testName, (Object)recording);
            }
            catch (TimeoutException te) {
                LOG.warn("Timed out while saving recording for test {}", (Object)testName, (Object)te);
            }
            catch (Exception ex) {
                LOG.warn("Failed to save recording for test {}", (Object)testName, (Object)ex);
            }
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        if (!this.startRecordingContainerManually) {
            this.startRecordingContainer();
        }
    }

    public void startRecordingContainer() {
        if (this.recordingContainer != null) {
            this.recordingContainer.start();
        }
    }

    protected void stopRecordingContainer() {
        if (this.recordingContainer != null) {
            try {
                this.recordingContainer.stop();
            }
            catch (Exception e) {
                LOG.warn("Failed to stop RecordingContainer", (Throwable)e);
            }
            this.recordingContainer = null;
        }
    }

    public String getContainerNameCleaned() {
        return this.getContainerName().replace("/", "");
    }

    public static enum RecordingMode {
        SKIP,
        RECORD_ALL,
        RECORD_FAILING;

    }

    public static class DefaultTestRecordingFileNameFactory
    implements TestRecordingFileNameFactory {
        public static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        public static final String PASSED = "PASSED";
        public static final String FAILED = "FAILED";

        @Override
        public String buildNameWithoutExtension(String testName, boolean succeeded) {
            return String.join((CharSequence)"-", succeeded ? PASSED : FAILED, testName, DTF.format(LocalDateTime.now(ZoneOffset.UTC)));
        }
    }

    public static interface TestRecordingFileNameFactory {
        public String buildNameWithoutExtension(String var1, boolean var2);
    }
}

