/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.testcontainers.selenium.containers.browser;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeleniumUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SeleniumUtils.class);
    public static final String DEFAULT_SELENIUM_VERSION = "4.19.1";
    private static String cachedVersion;

    private SeleniumUtils() {
    }

    public static String getClasspathSeleniumVersion() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        cachedVersion = SeleniumUtils.determineClasspathSeleniumVersion();
        return cachedVersion;
    }

    public static synchronized String determineClasspathSeleniumVersion() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        HashSet<String> seleniumVersions = new HashSet<String>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> manifests = classLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL manifestURL = manifests.nextElement();
                InputStream is = manifestURL.openStream();
                try {
                    Manifest manifest = new Manifest();
                    manifest.read(is);
                    String seleniumVersion = SeleniumUtils.getSeleniumVersionFromManifest(manifest);
                    if (seleniumVersion == null) continue;
                    seleniumVersions.add(seleniumVersion);
                    LOG.info("Selenium API version {} detected on classpath", (Object)seleniumVersion);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to determine Selenium-Version from selenium-api JAR Manifest", (Throwable)e);
        }
        if (seleniumVersions.isEmpty()) {
            LOG.warn("Failed to determine Selenium version from classpath - will use default version of {}", (Object)DEFAULT_SELENIUM_VERSION);
            return DEFAULT_SELENIUM_VERSION;
        }
        String foundVersion = (String)seleniumVersions.iterator().next();
        if (seleniumVersions.size() > 1) {
            LOG.warn("Multiple versions of Selenium API found on classpath - will select {}, but this may not be reliable", (Object)foundVersion);
        }
        return foundVersion;
    }

    public static String getSeleniumVersionFromManifest(Manifest manifest) {
        Attributes seleniumInfo;
        String seleniumVersion = null;
        Attributes buildInfo = manifest.getAttributes("Build-Info");
        if (buildInfo != null) {
            seleniumVersion = buildInfo.getValue("Selenium-Version");
        }
        if (seleniumVersion == null && (seleniumInfo = manifest.getAttributes("Selenium")) != null) {
            seleniumVersion = seleniumInfo.getValue("Selenium-Version");
        }
        return seleniumVersion;
    }
}

