/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.State;
import barsuift.simLife.environment.EnvironmentState;
import barsuift.simLife.time.TimeCounterState;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeState;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class UniverseState
implements State {
    private int age;
    private boolean fpsShowing;
    private Set<TreeState> trees;
    private Set<TreeLeafState> fallenLeaves;
    private EnvironmentState environment;
    private TimeCounterState timeCounter;

    public UniverseState() {
        this.age = 0;
        this.fpsShowing = false;
        this.trees = new HashSet<TreeState>();
        this.fallenLeaves = new HashSet<TreeLeafState>();
        this.environment = new EnvironmentState();
        this.timeCounter = new TimeCounterState();
    }

    public UniverseState(int age, boolean fpsShowing, Set<TreeState> trees, Set<TreeLeafState> fallenLeaves, EnvironmentState environment, TimeCounterState timeCounter) {
        this.age = age;
        this.fpsShowing = fpsShowing;
        this.trees = trees;
        this.fallenLeaves = fallenLeaves;
        this.environment = environment;
        this.timeCounter = timeCounter;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public boolean isFpsShowing() {
        return this.fpsShowing;
    }

    public void setFpsShowing(boolean fpsShowing) {
        this.fpsShowing = fpsShowing;
    }

    public Set<TreeState> getTrees() {
        return this.trees;
    }

    public void setTrees(Set<TreeState> trees) {
        this.trees = trees;
    }

    public Set<TreeLeafState> getFallenLeaves() {
        return this.fallenLeaves;
    }

    public void setFallenLeaves(Set<TreeLeafState> fallenLeaves) {
        this.fallenLeaves = fallenLeaves;
    }

    public EnvironmentState getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentState environment) {
        this.environment = environment;
    }

    public TimeCounterState getTimeCounter() {
        return this.timeCounter;
    }

    public void setTimeCounter(TimeCounterState timeCounter) {
        this.timeCounter = timeCounter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.age;
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.fallenLeaves == null ? 0 : ((Object)this.fallenLeaves).hashCode());
        result = 31 * result + (this.fpsShowing ? 1231 : 1237);
        result = 31 * result + (this.timeCounter == null ? 0 : this.timeCounter.hashCode());
        result = 31 * result + (this.trees == null ? 0 : ((Object)this.trees).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniverseState other = (UniverseState)obj;
        if (this.age != other.age) {
            return false;
        }
        if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
            return false;
        }
        if (this.fallenLeaves == null ? other.fallenLeaves != null : !((Object)this.fallenLeaves).equals(other.fallenLeaves)) {
            return false;
        }
        if (this.fpsShowing != other.fpsShowing) {
            return false;
        }
        if (this.timeCounter == null ? other.timeCounter != null : !this.timeCounter.equals(other.timeCounter)) {
            return false;
        }
        return !(this.trees == null ? other.trees != null : !((Object)this.trees).equals(other.trees));
    }

    public String toString() {
        return "UniverseState [age=" + this.age + ", fpsShowing=" + this.fpsShowing + ", trees=" + this.trees + ", fallenLeaves=" + this.fallenLeaves + ", environment=" + this.environment + ", timeCounter=" + this.timeCounter + "]";
    }
}

