/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.CallbacksInterface;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityTunnel;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandResponse;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.InfoResponse;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.MessageType;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.NodeType;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;
import java.util.ArrayList;
import java.util.List;

class CallbackMultiplexer
implements CallbacksInterface {
    private static final String TAG = "CallbackMultiplexer";
    private static final CallbackMultiplexer instance = new CallbackMultiplexer();
    private int internalCallbackCount = 0;
    private final List<CallbacksInterface> subscribers = new ArrayList<CallbacksInterface>(2);

    private CallbackMultiplexer() {
    }

    static CallbackMultiplexer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalAddSubscription(CallbacksInterface subscriber) {
        if (null == subscriber) {
            return;
        }
        this.internalRemoveSubscription(subscriber);
        List<CallbacksInterface> list = this.subscribers;
        synchronized (list) {
            this.subscribers.add(this.internalCallbackCount++, subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalRemoveSubscription(CallbacksInterface subscriber) {
        if (null == subscriber) {
            return;
        }
        List<CallbacksInterface> list = this.subscribers;
        synchronized (list) {
            if (this.subscribers.remove(subscriber)) {
                --this.internalCallbackCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSubscription(CallbacksInterface subscriber) {
        if (null == subscriber) {
            return;
        }
        this.removeSubscription(subscriber);
        List<CallbacksInterface> list = this.subscribers;
        synchronized (list) {
            this.subscribers.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(CallbacksInterface subscriber) {
        if (null == subscriber) {
            return;
        }
        List<CallbacksInterface> list = this.subscribers;
        synchronized (list) {
            int size = this.subscribers.size();
            int index = this.subscribers.indexOf(subscriber);
            if (0 > index || size <= index) {
                return;
            }
            if (index < this.internalCallbackCount) {
                Log.w(TAG, "remove called on internal subscription, ignoring");
                return;
            }
            this.subscribers.remove(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllExternalSubscribers() {
        List<CallbacksInterface> list = this.subscribers;
        synchronized (list) {
            this.subscribers.subList(this.internalCallbackCount, this.subscribers.size()).clear();
        }
    }

    @Override
    public void connectStatusCallback(Network network) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.connectStatusCallback(network);
        }
    }

    @Override
    public void deviceInfoCallback(Device device) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.deviceInfoCallback(device);
        }
    }

    @Override
    public void resourceCallback(Resource resource) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.resourceCallback(resource);
        }
    }

    @Override
    public void resourceCapabilityCallback(Capability capability) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.resourceCapabilityCallback(capability);
        }
    }

    @Override
    public void resourceAttributeCallback(Attribute attribute) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.resourceAttributeCallback(attribute);
        }
    }

    @Override
    public void commandStatusCallback(CommandResponse<?> command) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.commandStatusCallback(command);
        }
    }

    @Override
    public void networkListCallback(ArrayList<Network> networksList) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.networkListCallback(networksList);
        }
    }

    @Override
    public void deviceManagementStatusCallback(Device device, CommandResponse<?> executedCommand, Resource[] resourcesImpacted) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.deviceManagementStatusCallback(device, executedCommand, resourcesImpacted);
        }
    }

    @Override
    public void infoRequestCallback(InfoRequest infoRequest) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.infoRequestCallback(infoRequest);
        }
    }

    @Override
    public void infoResponseStatusCallback(Command.State state, InfoResponse infoResponse) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.infoResponseStatusCallback(state, infoResponse);
        }
    }

    @Override
    public void messageCallback(String title, String message, MessageType messageType) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.messageCallback(title, message, messageType);
        }
    }

    @Override
    public void advertiseResourceCallback(Resource resource) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.advertiseResourceCallback(resource);
        }
    }

    @Override
    public void infoRequestStatusCallback(Command.State state, InfoRequest infoRequest) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.infoRequestStatusCallback(state, infoRequest);
        }
    }

    @Override
    public void infoResponseCallback(InfoRequest request, InfoResponse infoResponse) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.infoResponseCallback(request, infoResponse);
        }
    }

    @Override
    public void resourceIncludedCallback(ArrayList<Resource> resources) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.resourceIncludedCallback(resources);
        }
    }

    @Override
    public void resourceExcludedCallback(Resource resource) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.resourceExcludedCallback(resource);
        }
    }

    @Override
    public void tunnelStatusCallback(Capability tunnel, long tunnelHandle, CapabilityTunnel.State state, int port) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.tunnelStatusCallback(tunnel, tunnelHandle, state, port);
        }
    }

    @Override
    public void zoneInfoCallback(Zone zone) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.zoneInfoCallback(zone);
        }
    }

    @Override
    public void zoneDeletedCallback(Network network, int zoneId) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.zoneDeletedCallback(network, zoneId);
        }
    }

    @Override
    public void sceneInfoCallback(Scene scene) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.sceneInfoCallback(scene);
        }
    }

    @Override
    public void sceneDeletedCallback(Network network, int sceneId) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.sceneDeletedCallback(network, sceneId);
        }
    }

    @Override
    public void ruleInfoCallback(Rule rule) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.ruleInfoCallback(rule);
        }
    }

    @Override
    public void ruleDeletedCallback(Network network, int ruleId) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.ruleDeletedCallback(network, ruleId);
        }
    }

    @Override
    public void nodeConnectionStatusCallback(Network network, long nodeId, NodeType nodeType, boolean isOnline) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.nodeConnectionStatusCallback(network, nodeId, nodeType, isOnline);
        }
    }

    @Override
    public void networkManagementCommandCallback(Network network, CommandResponse<?> response) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.networkManagementCommandCallback(network, response);
        }
    }

    @Override
    public void networkDataCallback(Network network) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.networkDataCallback(network);
        }
    }

    @Override
    public void leaveNetworkStatusCallback(Network network, Command.State status) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.leaveNetworkStatusCallback(network, status);
        }
    }

    @Override
    public void errorCallback(Throwable tr) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.errorCallback(tr);
        }
    }

    @Override
    public void receiveDataCallback(Network network, long sourceNodeId, String data) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.receiveDataCallback(network, sourceNodeId, data);
        }
    }

    @Override
    public void contentInfoCallback(Network network, long sourceNodeId, long contentTime, String data) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.contentInfoCallback(network, sourceNodeId, contentTime, data);
        }
    }

    @Override
    public void networkMetadataCallback(Network network) {
        for (CallbacksInterface subscriber : this.subscribers) {
            subscriber.networkMetadataCallback(network);
        }
    }
}

