/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;

public class CapabilityDoorLock
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.LOCK_CONTROL;

    protected CapabilityDoorLock(int id, Resource parent) {
        super(id, parent);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(UserType.class, (Object)new UserTypeSerializer());
        Command.GSON_BUILDER.registerTypeAdapter(UserStatus.class, (Object)new UserStatusSerializer());
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case LOCK: {
                command = (Command)gson.fromJson(commandParams, Lock.class);
                break;
            }
            case UNLOCK: {
                command = (Command)gson.fromJson(commandParams, Unlock.class);
                break;
            }
            case TOGGLE_DOOR_LOCK: {
                command = (Command)gson.fromJson(commandParams, ToggleDoorLock.class);
                break;
            }
            case SET_PIN_CODE: {
                command = (Command)gson.fromJson(commandParams, SetPin.class);
                break;
            }
            case CLEAR_PIN_CODE: {
                command = (Command)gson.fromJson(commandParams, ClearPin.class);
                break;
            }
            case SET_USER_STATUS: {
                command = (Command)gson.fromJson(commandParams, SetUserStatus.class);
                break;
            }
            case SET_USER_TYPE: {
                command = (Command)gson.fromJson(commandParams, SetUserType.class);
                break;
            }
            case GET_LOCK_STATUS: {
                command = (Command)gson.fromJson(commandParams, GetLockStatus.class);
                break;
            }
            case GET_PIN_CODE: {
                command = (Command)gson.fromJson(commandParams, GetPinCode.class);
                break;
            }
            case GET_USER_STATUS: {
                command = (Command)gson.fromJson(commandParams, GetUserStatus.class);
                break;
            }
            case GET_USER_TYPE: {
                command = (Command)gson.fromJson(commandParams, GetUserType.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class GetUserType
    extends Command<CommandId> {
        @SerializedName(value="userId")
        public long userId;

        public GetUserType() {
            super(CommandId.GET_USER_TYPE);
        }
    }

    public static class GetUserStatus
    extends Command<CommandId> {
        @SerializedName(value="userId")
        public long userId;

        public GetUserStatus() {
            super(CommandId.GET_USER_STATUS);
        }
    }

    public static class GetPinCode
    extends Command<CommandId> {
        @SerializedName(value="userId")
        public long userId;

        public GetPinCode() {
            super(CommandId.GET_PIN_CODE);
        }
    }

    public static class GetLockStatus
    extends Command<CommandId> {
        public GetLockStatus() {
            super(CommandId.GET_LOCK_STATUS);
        }
    }

    public static class SetUserType
    extends Command<CommandId> {
        @SerializedName(value="userId")
        public long userId;
        @SerializedName(value="userType")
        public UserType userType;

        public SetUserType() {
            super(CommandId.SET_USER_TYPE);
        }
    }

    public static class SetUserStatus
    extends Command<CommandId> {
        @SerializedName(value="userId")
        public long userId;
        @SerializedName(value="userStatus")
        public UserStatus userStatus;

        public SetUserStatus() {
            super(CommandId.SET_USER_STATUS);
        }
    }

    public static class ClearPin
    extends Command<CommandId> {
        @SerializedName(value="userId")
        public long userId;

        public ClearPin() {
            super(CommandId.CLEAR_PIN_CODE);
        }
    }

    public static class SetPin
    extends Command<CommandId> {
        @SerializedName(value="userId")
        public long userId;
        @SerializedName(value="userStatus")
        public UserStatus userStatus;
        @SerializedName(value="userType")
        public UserType userType;
        @SerializedName(value="pinRfidCode")
        public String pin;

        public SetPin() {
            super(CommandId.SET_PIN_CODE);
        }
    }

    public static class ToggleDoorLock
    extends Command<CommandId> {
        public ToggleDoorLock() {
            super(CommandId.TOGGLE_DOOR_LOCK);
        }
    }

    public static class Unlock
    extends Command<CommandId> {
        @SerializedName(value="timeoutMs")
        public long timeout;

        public Unlock() {
            super(CommandId.UNLOCK);
        }
    }

    public static class Lock
    extends Command<CommandId> {
        public Lock() {
            super(CommandId.LOCK);
        }
    }

    public static final class UserType {
        public static final int UNRESTRICTED_USER = 0;
        public static final int YEAR_DAY_SCH_USER = 1;
        public static final int WEEK_DAY_SCH_USER = 2;
        public static final int MASTER_USER = 3;
        public static final int NON_ACCESS_USER = 4;
        private final int userType;

        private UserType(int userType) {
            this.userType = userType;
        }

        public int rawValue() {
            return this.userType;
        }

        public static UserType unrestrictedUser() {
            return new UserType(0);
        }

        public static UserType yearDaySchUser() {
            return new UserType(1);
        }

        public static UserType weekDaySchUser() {
            return new UserType(2);
        }

        public static UserType masterUser() {
            return new UserType(3);
        }

        public static UserType nonAccessUser() {
            return new UserType(4);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserType that = (UserType)o;
            return this.userType == that.userType;
        }

        public int hashCode() {
            return this.userType;
        }

        public String toString() {
            return "UserType{userType=" + this.userType + '}';
        }
    }

    public static final class UserStatus {
        public static final int AVAILABLE = 0;
        public static final int ENABLED = 1;
        public static final int DISABLED = 2;
        private final int userStatus;

        private UserStatus(int userStatus) {
            this.userStatus = userStatus;
        }

        public int rawValue() {
            return this.userStatus;
        }

        public static UserStatus available() {
            return new UserStatus(0);
        }

        public static UserStatus enabled() {
            return new UserStatus(1);
        }

        public static UserStatus disabled() {
            return new UserStatus(2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserStatus that = (UserStatus)o;
            return this.userStatus == that.userStatus;
        }

        public int hashCode() {
            return this.userStatus;
        }

        public String toString() {
            return "UserStatus{userStatus=" + this.userStatus + '}';
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        LOCK,
        UNLOCK,
        TOGGLE_DOOR_LOCK,
        SET_PIN_CODE,
        CLEAR_PIN_CODE,
        SET_USER_STATUS,
        SET_USER_TYPE,
        GET_LOCK_STATUS,
        GET_PIN_CODE,
        GET_USER_STATUS,
        GET_USER_TYPE;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        LOCKED_FLAG,
        USER_ID_ARR,
        PIN_CODE_ARR,
        USER_STATUS_ARR,
        USER_TYPE_ARR;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }

    private static class UserStatusSerializer
    implements JsonSerializer<UserStatus>,
    JsonDeserializer<UserStatus> {
        private UserStatusSerializer() {
        }

        public UserStatus deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new UserStatus(json.getAsInt());
        }

        public JsonElement serialize(UserStatus userStatus, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)userStatus.rawValue());
        }
    }

    private static class UserTypeSerializer
    implements JsonSerializer<UserType>,
    JsonDeserializer<UserType> {
        private UserTypeSerializer() {
        }

        public UserType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new UserType(json.getAsInt());
        }

        public JsonElement serialize(UserType userType, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)userType.rawValue());
        }
    }
}

