/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityEnergyMetering
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.ENERGY_METERING;

    protected CapabilityEnergyMetering(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case RESET: {
                command = (Command)gson.fromJson(commandParams, Reset.class);
                break;
            }
            case GET_CONSUMPTION: {
                command = (Command)gson.fromJson(commandParams, GetConsumption.class);
                break;
            }
            case GET_DEMAND: {
                command = (Command)gson.fromJson(commandParams, GetDemand.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class GetDemand
    extends Command<CommandId> {
        @SerializedName(value="scale")
        public int scale;

        public GetDemand(int scale) {
            super(CommandId.GET_DEMAND);
            this.scale = scale;
        }
    }

    public static class GetConsumption
    extends Command<CommandId> {
        @SerializedName(value="scale")
        public int scale;

        public GetConsumption(int scale) {
            super(CommandId.GET_CONSUMPTION);
            this.scale = scale;
        }
    }

    public static class Reset
    extends Command<CommandId> {
        public Reset() {
            super(CommandId.RESET);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        RESET,
        GET_CONSUMPTION,
        GET_DEMAND;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        CONSUMPTION,
        DEMAND_WATT,
        LAST_READ_TIME_ARR,
        MULTIPLIER,
        DIVISOR,
        CONS_PROD_FMT_DIGITS,
        CONS_PROD_FMT_DECIMALS,
        DEMAND_FMT_DIGITS,
        DEMAND_DECIMALS,
        PRODUCTION,
        UNIT_OF_MEASURE;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

