/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;

public class CapabilityFireSensing
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.FIRE_SENSING;

    protected CapabilityFireSensing(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case ENABLE: {
                command = (Command)gson.fromJson(commandParams, Enable.class);
                break;
            }
            case DISABLE: {
                command = (Command)gson.fromJson(commandParams, Disable.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class Disable
    extends Command<CommandId> {
        public Disable() {
            super(CommandId.DISABLE);
        }
    }

    public static class Enable
    extends Command<CommandId> {
        public Enable() {
            super(CommandId.ENABLE);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        ENABLE,
        DISABLE;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        CO_DETECTED_FLAG,
        COOKING_IND_FLAG,
        SMOKE_DETECTED_FLAG,
        HEAT_DETECTED_FLAG,
        OVERHEAT_DETECTED_FLAG,
        COLD_DETECTED_FLAG,
        FIRE_DETECTED_FLAG;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

