/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Listener;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class CapabilityMediaStreaming
extends Capability {
    private static final String TAG = "CapabilityMediaStreaming";
    public static final Capability.CapabilityId ID = Capability.CapabilityId.MEDIA_STREAM;

    protected CapabilityMediaStreaming(int id, Resource parent) {
        super(id, parent);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(RecordMode.class, (Object)new RecordModeParser());
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    public static Capability getHandlingCapability(long streamHandle) {
        Capability capability = null;
        Resource resource = CocoClient.getInstance().getNativeHandler().getHandlingResource(streamHandle);
        if (null != resource) {
            capability = (Capability)resource.getCapability(Capability.CapabilityId.MEDIA_STREAM);
        }
        return capability;
    }

    public static long getHandlingStreamId(long streamHandle) {
        return CocoClient.getInstance().getNativeHandler().getHandlingStreamId(streamHandle);
    }

    public static int getHandlingStreamSessionId(long streamHandle) {
        return CocoClient.getInstance().getNativeHandler().getHandlingStreamSessionId(streamHandle);
    }

    public static int[] getHandlingChannelPorts(long streamHandle) {
        return CocoClient.getInstance().getNativeHandler().getHandlingChannelPorts(streamHandle);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case STREAM_START: 
            case STREAM_STOP: {
                command = null;
                break;
            }
            case RECORD_START: {
                command = (Command)gson.fromJson(commandParams, StartRecording.class);
                break;
            }
            case RECORD_STOP: {
                command = (Command)gson.fromJson(commandParams, StopRecording.class);
                break;
            }
            case RECORD_CONFIG: {
                command = (Command)gson.fromJson(commandParams, ConfigRecording.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public int[] getAvailableChannelPorts(int portCount) {
        return ((Device)this.getParent().getParent()).getAvailableChannelPorts(portCount);
    }

    public int[] startStream(long streamId, int streamSessionId, String streamDescription, TransportType[] transportTypes, MediaSessionType sessionType, long timeout, MediaStreamListener listener) {
        int[] freePorts = ((Device)this.getParent().getParent()).getAvailableChannelPorts(transportTypes.length);
        if (null == freePorts) {
            throw new RuntimeException("cannot find free ports");
        }
        Log.d(TAG, "freePorts: " + Arrays.toString(freePorts));
        this.startStream(streamId, streamSessionId, streamDescription, freePorts, transportTypes, sessionType, timeout, listener);
        return freePorts;
    }

    public void startStream(long streamId, int streamSessionId, String streamDescription, int[] channelPorts, TransportType[] transportTypes, MediaSessionType sessionType, long timeout, MediaStreamListener listener) {
        Objects.requireNonNull(listener);
        CocoClient.getInstance().getNativeHandler().startMediaStream(this, streamId, streamSessionId, streamDescription, channelPorts, transportTypes, sessionType, timeout, listener);
    }

    public int sendData(long streamHandle, int channelPort, long frameIndex, int frameType, long frameDuration, long framePts, byte[] data, int offset, int size) {
        return this.sendData(streamHandle, channelPort, frameIndex, frameType, frameDuration, framePts, ByteBuffer.wrap(data, offset, size));
    }

    public synchronized int sendData(long streamHandle, int channelPort, long frameIndex, int frameType, long frameDuration, long framePts, ByteBuffer data) {
        return CocoClient.getInstance().getNativeHandler().sendMediaStreamData(streamHandle, channelPort, frameIndex, frameType, frameDuration, framePts, data);
    }

    public void stopStream(long streamHandle) {
        CocoClient.getInstance().getNativeHandler().stopMediaStream(streamHandle);
    }

    @Override
    protected <T extends Capability.CommandId> void interceptCommand(Command<T> command) {
        if (CommandId.STREAM_START == command.getCommandId() || CommandId.STREAM_STOP == command.getCommandId()) {
            throw new IllegalArgumentException("use individual functions instead of sendResourceCommand");
        }
        super.interceptCommand(command);
    }

    public static class ConfigRecording
    extends Command<CommandId> {
        @SerializedName(value="recordMode")
        public RecordMode recordMode;
        @SerializedName(value="size")
        public int size;
        @SerializedName(value="timeMs")
        public long duration;
        @SerializedName(value="recordCoolOffTimeMs")
        public long coolOffTime;

        public ConfigRecording() {
            super(CommandId.RECORD_CONFIG);
        }
    }

    public static class StopRecording
    extends Command<CommandId> {
        @SerializedName(value="streamIdArray")
        public int[] streamIds;

        public StopRecording() {
            super(CommandId.RECORD_STOP);
        }
    }

    public static class StartRecording
    extends Command<CommandId> {
        @SerializedName(value="streamIdArray")
        public int[] streamIds;
        @SerializedName(value="streamDescriptionArray")
        public String[] streamDescriptions;

        public StartRecording() {
            super(CommandId.RECORD_START);
        }
    }

    public static abstract class DefaultMediaStreamListenerMultiplexer
    implements MediaStreamListenerMultiplexer {
        private final HashMap<Integer, MediaStreamListener> channelPortCallbackMap = new HashMap(10);

        @Override
        public boolean hasCallbackHandlerAssigned(int channelPort) {
            return this.channelPortCallbackMap.containsKey(channelPort);
        }

        @Override
        public void removeChannelHandleCallback(int channelPort) {
            this.channelPortCallbackMap.remove(channelPort);
        }

        @Override
        public MediaStreamListener getCallbackHandler(int channelPort) {
            return this.channelPortCallbackMap.get(channelPort);
        }

        @Override
        public synchronized void setChannelHandleCallback(int channelPort, MediaStreamListener callback) {
            this.channelPortCallbackMap.put(channelPort, callback);
        }
    }

    public static interface MediaStreamListenerMultiplexer
    extends MediaStreamListener {
        public boolean hasCallbackHandlerAssigned(int var1);

        public MediaStreamListener getCallbackHandler(int var1);

        public void setChannelHandleCallback(int var1, MediaStreamListener var2);

        public void removeChannelHandleCallback(int var1);

        @Override
        default public void onStatusChanged(long streamHandle, int channelPort, Status status) {
            MediaStreamListener callback = this.getCallbackHandler(channelPort);
            if (null != callback) {
                callback.onStatusChanged(streamHandle, channelPort, status);
            }
        }

        @Override
        default public void onDataReceived(long streamHandle, int channelPort, long frameIndex, int frameType, long frameDuration, long framePts, ByteBuffer data) {
            MediaStreamListener callback = this.getCallbackHandler(channelPort);
            if (null != callback) {
                callback.onDataReceived(streamHandle, channelPort, frameIndex, frameType, frameDuration, framePts, data);
            }
        }
    }

    private static final class RecordModeParser
    implements JsonSerializer<RecordMode>,
    JsonDeserializer<RecordMode> {
        private RecordModeParser() {
        }

        public RecordMode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return RecordMode.getEnum(json.getAsInt());
        }

        public JsonElement serialize(RecordMode src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    public static interface MediaStreamListener
    extends Listener {
        default public void onStatusChanged(long streamHandle, int channelPort, Status status) {
        }

        default public void onDataReceived(long streamHandle, int channelPort, long frameIndex, int frameType, long frameDuration, long framePts, ByteBuffer data) {
        }
    }

    public static enum RecordMode {
        MANUAL_STOP,
        TIME,
        SIZE;


        static RecordMode getEnum(int index) {
            return (RecordMode)Utils.findEnum((int)index, (Enum[])RecordMode.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum MediaSessionType {
        BUFFERED,
        LIVE;


        static MediaSessionType getEnum(int index) {
            return (MediaSessionType)Utils.findEnum((int)index, (Enum[])MediaSessionType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum Status {
        UNKNOWN,
        OPENED,
        FAILED,
        CLOSED,
        TIMEOUT,
        MAX_CLIENT_REACHED;


        static Status getEnum(int index) {
            return (Status)Utils.findEnum((int)index, (Enum[])Status.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum TransportType {
        TCP,
        UDP,
        RTP_UDP;


        static TransportType getEnum(int index) {
            return (TransportType)Utils.findEnum((int)index, (Enum[])TransportType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        STREAM_START,
        STREAM_STOP,
        RECORD_START,
        RECORD_STOP,
        RECORD_CONFIG;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        DESCRIPTOR,
        ID_ARR,
        ACTIVE_CLIENTS_ARR,
        MAX_ACTIVE_CLIENTS_ARR,
        REC_STATUS_ARR,
        REC_SUPPORTED_ARR,
        RECORDING_IN_PROGRESS,
        CONTENT_SEND_BUFFER_SIZE_ARR,
        CONTENT_RECEIVE_BUFFER_SIZE_ARR;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }

    public static final class FrameTypes {
        public static final int NONE = 0;
        public static final int KEY = 1;
    }
}

